% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_function_with_LLM.R
\name{summarise_function_from_arguments_and_body}
\alias{summarise_function_from_arguments_and_body}
\title{Summarise a function from its arguments and body}
\usage{
summarise_function_from_arguments_and_body(
  foo_name,
  foo_arguments,
  foo_body,
  foo_title,
  foo_desc,
  model_name = "gpt-3.5-turbo-0125",
  llm_api_url = Sys.getenv("LLM_API_URL"),
  llm_api_key = Sys.getenv("LLM_API_KEY")
)
}
\arguments{
\item{foo_name}{function name}

\item{foo_arguments}{vector of arguments}

\item{foo_body}{single character containing the unparsed body}

\item{foo_title}{function title}

\item{foo_desc}{function description}

\item{model_name}{name of the LLM to use (default gpt-3.5-turbo-0125)}

\item{llm_api_url}{url to the API for the LLM}

\item{llm_api_key}{key for the API for the LLM}
}
\value{
response from LLM containing all pertinant information & tokens used
}
\description{
Summarise a function using a LLM via API and retrieve the result
}
\examples{
\dontrun{
tmp <- summarise_function_from_arguments_and_body(
  foo_arguments = LETTERS[1:3],
  foo_body = "D <- A+B+C; return(D)",
  model_name = "gpt-3.5-turbo-0125",
  llm_api_url = Sys.getenv("LLM_API_URL"),
  llm_api_key = Sys.getenv("LLM_API_KEY"),
  foo_desc = "add three numbers, these numbers relate to the number of apples on three trees",
  foo_title = "apple adder",
  foo_name = "apple_add"
)
httr::content(tmp)
}

}
