% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algos.R
\name{my.shortterm}
\alias{my.shortterm}
\title{Fit short term algorithm and make the prediction}
\usage{
my.shortterm(prepedTS, n_pred, smooth_window = 2)
}
\arguments{
\item{prepedTS}{A list created by the \code{prepare.ts()} function}

\item{n_pred}{Int number of periods to forecast forward (eg n_pred = 12 will lead to one year of prediction for monthly time series).
Note that this algorithm cannot predict further than one year}

\item{smooth_window}{Int specifying the number of periods to consider for computing the evolution rate that will be applied for the forecast}
}
\value{
A dataframe with 4 columns : date, average prediction, upper and lower 95% confidence interval bounds
}
\description{
Fit short term algorithm and make the prediction
}
\details{
this algorithm uses data of the last year and makes the prediction
taking into account the seasonality and the evolution of the previous periods' evolution
}
\examples{
library(lubridate)
library(dplyr)
dates <- seq(as_date("2000-01-01"),as_date("2010-12-31"),"quarter")
values <- rnorm(length(dates))
my.ts <- prepare.ts(dates,values,"quarter",complete = 0)
my.shortterm(my.ts,n_pred=4)
}
