% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{get_best_models}
\alias{get_best_models}
\title{get_best_models}
\usage{
get_best_models(autofit, return_fitness = FALSE, verbose = TRUE)
}
\arguments{
\item{autofit}{Output of the autohrf function.}

\item{return_fitness}{Whether to return models or fitness.}

\item{verbose}{Whether to print information or only return the result.}
}
\value{
Returns a list containing the best models for each of the provided
constraints.
}
\description{
Returns and prints the best fitted model for each of the specs
used in autohrf.
}
\examples{
# prepare model specs
model3 <- data.frame(
  event        = c("encoding", "delay", "response"),
  start_time   = c(0,          2.65,     12.5),
  end_time     = c(3,          12.5,     16)
)

model4 <- data.frame(
  event        = c("fixation", "target", "delay", "response"),
  start_time   = c(0,          2.5,      2.65,    12.5),
  end_time     = c(2.5,        3,        12.5,    15.5)
)

model_constraints <- list(model3, model4)

# run autohrf
df <- flanker
autofit <- autohrf(df, model_constraints, tr = 2.5,
                   population = 2, iter = 2, cores = 1)

# print best models
get_best_models(autofit)

}
