% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avlr.R
\name{avlr}
\alias{avlr}
\alias{avlr.default}
\alias{avlr.imu_avar}
\title{Computes the Allan Variance Linear Regression estimator}
\usage{
avlr(x, ...)

\method{avlr}{default}(
  x,
  qn = NULL,
  wn = NULL,
  rw = NULL,
  dr = NULL,
  ci = FALSE,
  B = 100,
  alpha = 0.05,
  ...
)

\method{avlr}{imu_avar}(
  x,
  qn_gyro = NULL,
  wn_gyro = NULL,
  rw_gyro = NULL,
  dr_gyro = NULL,
  qn_acc = NULL,
  wn_acc = NULL,
  rw_acc = NULL,
  dr_acc = NULL,
  B = 100,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{x}{A \code{vec} of time series observations or an \code{imu} object.}

\item{...}{Further arguments passed to other methods.}

\item{qn}{A \code{vec} specifying on which scales the parameters of a Quantization Noise (QN) should be computed.}

\item{wn}{A \code{vec} specifying on which scales the parameters of a White Noise (WN) should be computed.}

\item{rw}{A \code{vec} specifying on which scales the parameters of a Random Wakk (RW) should be computed.}

\item{dr}{A \code{vec} specifying on which scales the parameters of a Drift (DR) should be computed.}

\item{ci}{A \code{boolean} to compute parameter confidence intervals.}

\item{B}{A \code{double} for the number of bootstrap replicates to compute the parameter confidence intervals.}

\item{alpha}{A \code{double} defining the level of the confidence interval (1 - `alpha`).}

\item{qn_gyro}{A \code{vec} specifying on which scales the parameters of a Quantization Noise (QN) should be computed for the gyroscope component.}

\item{wn_gyro}{A \code{vec} specifying on which scales the parameters of a White Noise (WN) should be computed for the gyroscope component.}

\item{rw_gyro}{A \code{vec} specifying on which scales the parameters of a Random Wakk (RW) should be computed for the gyroscope component.}

\item{dr_gyro}{A \code{vec} specifying on which scales the parameters of a Drift (DR) should be computed for the gyroscope component.}

\item{qn_acc}{A \code{vec} specifying on which scales the parameters of a Quantization Noise (QN) should be computed for the accelerometer component.}

\item{wn_acc}{A \code{vec} specifying on which scales the parameters of a White Noise (WN) should be computed for the accelerometer component.}

\item{rw_acc}{A \code{vec} specifying on which scales the parameters of a Random Wakk (RW) should be computed for the accelerometer component.}

\item{dr_acc}{A \code{vec} specifying on which scales the parameters of a Drift (DR) should be computed for the accelerometer component.}
}
\value{
If the input \code{x} is a \code{vec}, then the function returns a \code{list} that contains:
\itemize{
 \item "estimates": The estimated value of the parameters.
 \item "implied_ad": The Allan deviation implied by the estimated parameters.
 \item "implied_ad_decomp": The Allan deviation implied by the estimated parameters for each individual model (if more than one is specified).
 \item "av": The \code{avar} object computed from the provided data.
}
If the input \code{x} is of the class \code{imu_avar}, then the function returns a \code{list} that contains:
\itemize{
 \item "gyro": The estimation results correseponding to the gyroscope component.
 \item "acc": The estimation results correseponding to the accelerometer component.
 \item "imu_av": The \code{imu_avar} object computed based on the IMU data.
}
}
\description{
Estimate the parameters of time series models based on the Allan Variance Linear Regression (AVLR) approach
}
\examples{
\donttest{
set.seed(999)

N = 100000
Xt = rnorm(N) + cumsum(rnorm(N, 0, 3e-3))

av = avar(Xt)
plot(av)

# Input time series
fit = avlr(Xt, wn = 1:8, rw = 11:15)
fit

# Input directly Allan variance
fit = avlr(av, wn = 1:8, rw = 11:15)
fit

# Plot functions
plot(fit)
plot(fit, decomp = TRUE)
plot(fit, decomp = TRUE, show_scales = TRUE)
}
}
