% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avar.r
\name{summary.avar}
\alias{summary.avar}
\title{Summary Allan Variance}
\usage{
\method{summary}{avar}(object, ...)
}
\arguments{
\item{object}{A \code{avar} object.}

\item{...}{Additional arguments affecting the summary produced.
A \code{table} that contains:
\itemize{
 \item "Time": The averaging time at each level.
 \item "AVar": The estimated Allan variance.
 \item "ADev": The estimated Allan deviation.
 \item "Lower CI": The lower bound of the confidence interval for the Allan deviation (ADev).
 \item "Upper CI": The upper bound of the confidence interval for the Allan deviation (ADev).
}}
}
\description{
Displays the summary table of the output of the `avar()` function
}
\examples{
set.seed(999)
Xt = rnorm(10000)
out = avar(Xt)
summary(out)

}
