% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_utils.R
\name{run_experiment}
\alias{run_experiment}
\title{Run an experiment using Thompson Sampling.}
\usage{
run_experiment(
  ys,
  floor_start,
  floor_decay,
  batch_sizes,
  xs = NULL,
  balanced = NULL
)
}
\arguments{
\item{ys}{Matrix. Potential outcomes of shape \code{[A, K]}, where \code{A} is the number of observations and \code{K} is the number of arms. Must not contain NA values.}

\item{floor_start}{Numeric. Specifies the initial value for the assignment probability floor. It ensures that at the start of the process, no assignment probability falls below this threshold. Must be a positive number.}

\item{floor_decay}{Numeric. Decay rate of the floor. The floor decays with the number of observations in the experiment such that at each point in time, the applied floor is: \code{floor_start/(s^{floor_decay})}, where \code{s} is the starting index for a batched experiment, or the observation index for an online experiment. Must be a number between 0 and 1 (inclusive).}

\item{batch_sizes}{Integer vector. Size of each batch. Must be positive integers.}

\item{xs}{Optional matrix. Covariates of shape \code{[A, p]}, where \code{p} is the number of features, if the LinTSModel is contextual. Default is \code{NULL}. Must not contain NA values.}

\item{balanced}{Optional logical. Indicates whether to balance the batches. Default is \code{NULL}.}
}
\value{
A list containing the pulled arms (\code{ws}), observed rewards (\code{yobs}), assignment probabilities (\code{probs}), and the fitted bandit model (\code{fitted_bandit_model}).
}
\description{
Runs a LinTS or non-contextual TS bandit experiment, given potential outcomes and covariates.
}
\examples{
set.seed(123)
A <- 1000
K <- 4
xs <- matrix(runif(A * K), nrow = A, ncol = K)
ys <- matrix(rbinom(A * K, 1, 0.5), nrow = A, ncol = K)
batch_sizes <- c(250, 250, 250, 250)
results <- run_experiment(ys = ys,
                          floor_start = 1/K,
                          floor_decay = 0.9,
                          batch_sizes = batch_sizes,
                          xs = xs)

}
