% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.bartcs}
\alias{plot.bartcs}
\title{Draw plot for \code{bartcs} object}
\usage{
\method{plot}{bartcs}(x, method = NULL, parameter = NULL, ...)
}
\arguments{
\item{x}{A \code{bartcs} object.}

\item{method}{"\code{pip}" for posterior inclusion probability plot
or "\code{trace}" for trace plot.}

\item{parameter}{Parameter for traceplot.}

\item{...}{Additional arguments for PIP plot.
Check \code{?ggcharts::bar_chart} for possible arguments.}
}
\value{
A \code{ggplot} object of either PIP plot or trace plot.
}
\description{
Two options are available:
posterior inclusion probability (PIP) plot and trace plot.
}
\details{
\subsection{PIP plot}{

When a posterior sample is sampled during training,
\code{separate_bart()} or \code{single_bart()} also counts
which variables are included in the model and
compute PIP for each variable.
For \code{bartcs} object \code{x},
this is stored in \code{x$var_count} and \code{x$var_prob} respectively.
\code{plot(method = "pip")} uses this information and
draws plot using \code{ggcharts::bar_chart()}.
}

\subsection{Traceplot}{

Parameters are recorded for each MCMC iterations.
Parameters include "\code{SATE}", "\code{Y1}", "\code{Y0}", "\code{dir_alpha}",
and either "\code{sigma2_out}" from \code{single_bart()}
or "\code{sigma2_out1}" and "\code{sigma2_out0}" from \cr
\code{separate_bart()}.
Vertical line indicates burn-in.
}
}
\examples{
data(ihdp, package = "bartcs")
x <- single_bart(
  Y               = ihdp$y_factual,
  trt             = ihdp$treatment,
  X               = ihdp[, 6:30],
  num_tree        = 10,
  num_chain       = 2,
  num_post_sample = 20,
  num_burn_in     = 10,
  verbose         = FALSE
)

# PIP plot
plot(x, method = "pip")
plot(x, method = "pip", top_n = 10)
plot(x, method = "pip", threshold = 0.5)
# Check `?ggcharts::bar_chart` for other possible arguments.

# trace plot
plot(x, method = "trace")
plot(x, method = "trace", "Y1")
plot(x, method = "trace", "dir_alpha")

}
