% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic_data.R
\name{synthetic_data}
\alias{synthetic_data}
\title{Synthetic dataset for simulation}
\usage{
synthetic_data(N = 300, P = 100, seed = 42, binary_trt = TRUE)
}
\arguments{
\item{N}{Number of observations for dataset. The default value is set to 300.}

\item{P}{Number of potential confounders for dataset.
Need to set X > 7 for data generation. The default value is set to 100.}

\item{seed}{Seed value for simulation. The default value is set to 42.}

\item{binary_trt}{Whether the treatment is binary. The default value is set to TRUE.}
}
\value{
Provide list with the following components

\item{Y}{A vector of outcome values.}
\item{Trt}{A vector of binary treatment values.}
\item{X}{A matrix of potential confounders.}
}
\description{
Create synthetic dataset for simulation.
}
\details{
\code{synthetic_data()} generates synthetic dataset for Scenario 1 from
Kim et al. (2023). Among possible confounders, X1 - X5 are true confounders.
}
\examples{
synthetic_data()

}
\references{
Kim, C., Tec, M., & Zigler, C. M. (2023).
Bayesian Nonparametric Adjustment of Confounding, \emph{Biometrics}
\doi{10.1111/biom.13833}
}
