#' NLSY IQ.
#'
#' NLSY data to analyse the effect of maternal behaviour on 
#' children's IQ score. Natality detail files are from 2001 and 2002. 
#' Data is from the NLSY Children and Young Adults panel.
#' 
#' @format A data frame with 6514 observations on 13 variables:
#' \describe{
#' \item{\code{iq_std}}{standardized IQ score, PIAT score}
#' \item{\code{BF_months}}{months of breast feeding}
#' \item{\code{mom_drink_preg_all}}{did mother drink at all during pregnancy}
#' \item{\code{lbw_preterm}}{low birth weight + preterm}
#' \item{\code{age}}{age of child}
#' \item{\code{female}}{child female}
#' \item{\code{black}}{mother black}
#' \item{\code{motherAge}}{age of mother}
#' \item{\code{motherEDU}}{years of schooling of mother}
#' \item{\code{mom_married}}{is the mother married?}
#' \item{\code{income}}{annual income of mother}
#' \item{\code{sex}}{child sex}
#' \item{\code{race}}{race of mother}
#' }
#'
#' 
#'
#' Source: \url{https://drive.google.com/file/d/1O1W9dP8F3B1DnAZGBegpoqCfysUrn7Uc/view?usp=sharing}
#'
#' @examples 
#' ## Load data set
#' data("NLSY_IQ")
#' ## See names of variables
#' names(NLSY_IQ)
#'
"NLSY_IQ"

#' NLSY Birth Weight.
#'
#' NLSY data to analyse the effect of maternal behaviour on 
#' children's birth weight. Natality detail files are from 2001 and 2002. 
#' Data is from the NLSY Children and Young Adults panel.
#' 
#' @format A data frame with 7686 observations on 13 variables:
#' \describe{
#' \item{\code{birth_wt}}{birth weight, grams}
#' \item{\code{BF_months}}{months of breast feeding}
#' \item{\code{mom_drink_preg_all}}{did the mother drink at all during pregnancy}
#' \item{\code{lbw_preterm}}{low birth weight + preterm}
#' \item{\code{age}}{age of child}
#' \item{\code{female}}{child female}
#' \item{\code{black}}{mother black}
#' \item{\code{motherAge}}{age of mother}
#' \item{\code{motherEDU}}{years of schooling of mother}
#' \item{\code{mom_married}}{is the mother married?}
#' \item{\code{income}}{annual income of mother}
#' \item{\code{sex}}{years of schooling of mother}
#' \item{\code{race}}{race of mother}
#' \item{\code{gesweek}}{gestation week}
#' \item{\code{any_smoke}}{did the mother smoke at all during pregnancy}
#' }
#'
#' 
#'
#' Source: \url{https://drive.google.com/file/d/1O1W9dP8F3B1DnAZGBegpoqCfysUrn7Uc/view?usp=sharing}
#'
#' @examples 
#' ## Load data set
#' data("NLSY_BW")
#' ## See names of variables
#' names(NLSY_BW)
#'
"NLSY_BW"
