#' Compute roots of the cubic equation
#'
#' @param parameters A vector of parameters (real numbers) that is generated by estimating the short, intermediate and auxiliary regressions.
#' @param mydelta Value of delta (real number). 
#' @param Rmax Value of Rmax (real number).
#'
#' @return A vector containing the three roots of the cubic equation defined by the parameters, delta and Rmax.
#' @export
#'
#' 
mycubic <- function(parameters,mydelta,Rmax){
  roots <- with(partocoef(parameters,mydelta,Rmax),{
    polyroot(c(d,c,b,a))
  })
  # Return the three solutions
  return(roots)
}
