% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_par.R
\name{collect_par}
\alias{collect_par}
\title{Collect parameters from the short, intermediate and auxiliary regressions}
\usage{
collect_par(data, outcome, treatment, control, other_regressors = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{outcome}{The name of the outcome variable (must be present in the data frame).}

\item{treatment}{The name of the treatment variable (must be present in the data frame).}

\item{control}{Control variables to be added to the intermediate regression.}

\item{other_regressors}{Subset of control variables to be added in the short regression (default is NULL).}
}
\value{
A data frame with the following columns:
\item{beta0}{Treatment effect in the short regression}
\item{R0}{R-squared in the short regression}
\item{betatilde}{Treatment effect in the intermediate regression}
\item{Rtilde}{R-squared in the intermediate regression}
\item{sigmay}{Standard deviation of outcome variable}
\item{sigmax}{Standard deviation of treatment variable}
\item{taux}{Standard deviation of residual in auxiliary regression}
}
\description{
Collect parameters from the short, intermediate and auxiliary regressions
}
\examples{

## Load data set
data("NLSY_IQ")
 
## Set age and race as factor variables
NLSY_IQ$age <- factor(NLSY_IQ$age)
NLSY_IQ$race <- factor(NLSY_IQ$race)
   
## Collect parameters from the short, intermediate and auxiliary regressions
parameters <- collect_par(
data = NLSY_IQ, outcome = "iq_std", 
treatment = "BF_months", 
control = c("age","sex","income","motherAge","motherEDU","mom_married","race"),
other_regressors = c("sex","age"))

## See results
(parameters)

}
