% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/32_aShortingStock.R
\name{aShortStock}
\alias{aShortStock}
\title{Calculates per share Profit and Loss at covering of the shorted stock and draws its graph in the Plots tab.}
\usage{
aShortStock(
  ST,
  S0,
  C = 0,
  hl = 0.8,
  hu = 1.1,
  xlab = "Share Price  @ covering",
  ylab = " Profit / Loss [PnL] at covering ($)",
  main = "Shorting a Stock [ PnL]"
)
}
\arguments{
\item{ST}{a number.}

\item{S0}{a number.}

\item{C}{a number.}

\item{hl}{a number.}

\item{hu}{a number.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
On initiation, this is a net credit Strategy and results in net cash inflow in the form of receiving the unit price of shorted share. On the day of the covering the trader or investor has to buy the underlying stock at the price at the time of covering. If the bearish outlook of the trader is as expected and the stock price falls then the trader makes the profit as shown in the graph (Hull, 2022).
}
\details{
According to the information provided by Hull (2019), this method is developed, and the given examples are created to compute per share Profit and Loss at covering of the shorted stock and draws its graph in the Plots tab.
}
\examples{
aShortStock(51,52)
aShortStock(1000,1009,hl=0.995,hu=1.015)
}
\references{
Hull, J. C. (2022). Options, Futures, and Other Derivatives (11th ed.). Pearson Education (US). https://bookshelf.vitalsource.com/books/9780136940043
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
