% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binspp_auxiliary.R
\name{simulate.output_estintp}
\alias{simulate.output_estintp}
\title{Simulation from the fitted model}
\usage{
\method{simulate}{output_estintp}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{list, output of the main function \code{\link[=estintp]{estintp()}}.}

\item{nsim}{number of patterns to be simulated.}

\item{seed}{a single value, interpreted as an integer, or NULL.}

\item{...}{additional optional arguments.}
}
\value{
Either a single point pattern or a list of point patterns.
}
\description{
One or more point patterns are simulated using
the point estimates provided by the MCMC output.
}
\details{
A given number of point patterns is simulated from
the fitted model. The point pattern used for estimation determines
the observation window and the covariates to be used. Point estimates
from the output of the MCMC run are used as parameter values.
}
\examples{

library(spatstat)
library(stats)
# Prepare the dataset:
X <- trees_N4
x_left <- x_left_N4
x_right <- x_right_N4
y_bottom <- y_bottom_N4
y_top <- y_top_N4

z_beta <- list(refor = cov_refor, slope = cov_slope)
z_alpha <- list(tmi = cov_tmi, tdensity = cov_tdensity)
z_omega <- list(slope = cov_slope, reserv = cov_reserv)

# Determine the union of rectangles:
W <- owin(c(x_left[1], x_right[1]), c(y_bottom[1], y_top[1]))
if (length(x_left) >= 2) {
  for (i in 2:length(x_left)) {
    W2 <- owin(c(x_left[i], x_right[i]), c(y_bottom[i], y_top[i]))
    W <- union.owin(W, W2)
  }
}

# Dilated observation window:
W_dil <- dilation.owin(W, 100)


# Default parameters for prior distributions:
control <- list(NStep = 100, BurnIn = 20, SamplingFreq = 5)


# MCMC estimation:
Output <- estintp(X = X, control = control, x_left = x_left, x_right = x_right,
    y_bottom = y_bottom, y_top = y_top, W_dil = W_dil, z_beta = z_beta,
    z_alpha = z_alpha, z_omega = z_omega, verbose = FALSE)


# Simulation from the fitted model:
pattern <- simulate(Output)
plot(pattern)

}
