% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpy1.r
\name{interpy1}
\alias{interpy1}
\title{A simple linear interpolation function applicable to two vectors
(\eqn{X} and \eqn{Y}), when the first element of \eqn{Y} is missing.}
\usage{
interpy1(xs = xs, ys = ys)
}
\arguments{
\item{xs}{A numeric vector of length 3}

\item{ys}{A numeric vector of length 3, with the first position empty.}
}
\value{
The interpolated value for the first element of vector \eqn{Y}.
}
\description{
A simple linear interpolation function applicable to two vectors
(e.g., \eqn{X} and \eqn{Y}) of length three, suitable when the first
element of \eqn{Y} is missing.
}
\examples{
x<-c(0.2,0.8,1.3)
y<-c(NA,41,38)
interpy1(xs=x,ys=y)
}
\author{
Christian Salas-Eljatib.
}
