% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-mortaforest.r
\docType{data}
\name{mortaforest}
\alias{mortaforest}
\title{Climatic, forest structure and forest mortality variables in California (USA)}
\format{
The data frame contains four variables as follows:
\describe{
\item{live.bah}{Live basal area from the GNN dataset}
\item{live.tph}{Live trees per hectare from the GNN dataset}
\item{pos.x}{rank-order x-position of the grid cell (position \code{1} is
western-most)}
\item{pos.y}{rank-order y-position of the grid cell (position \code{1} is
northern-most)}
\item{alb.x}{x-coordinate of the grid cell centroid in California
Albers (EPSG 3310)}
\item{alb.y}{y-coordinate of the grid cell centroid in California
Albers (EPSG 3310)}
\item{mort.bin}{\code{1}= dead trees observed in grid cell. \code{0}= no dead
trees observed}
\item{mort.tph}{Dead trees per hectare from the aggregated ADS dataset}
\item{mort.tpa}{Dead trees per acre from the aggregated ADS dataset}
\item{year}{Year of the ADS flight. Most flights occurred from May-August.}
\item{Defnorm}{Mean annual climatic water deficit for the grid cell, for
Oct 1-Sept 31 water year, averaged from 1981-2015}
\item{Def0}{Climatic water deficit for the grid cell during the Oct-Sept
water year overlapping the summer ADS flight of the given year}
\item{Defz0}{Z-score for climatic water deficit for the given grid
cell/water year. Calculated as (\code{Def0}--\code{Defnorm})/(standard deviation in
deficit among all years 1981-2015 for the given grid cell)}
\item{Defz1}{Z-score for climatic water deficit for the given grid cell
in the preceeding water year.}
\item{Defz2}{Z-score for climatic water deficit for the given grid cell
two water years prior.}
\item{Tz0}{Z-score for temperature for the given grid cell/year.}
\item{Pz0}{Z-score for precipitation for the given grid cell/year.}
\item{Defquant}{FDCI variable. Quantile of \code{Defnorm} of the given grid cell,
relative to the \code{Defnorm} of all other grid cells with a basal area
within 2.5 m\eqn{^{2}}{^2}/ha of the given cell is basal area.}
}
}
\source{
The data were obtained from the DRYAD repository \doi{10.5061/dryad.7vt36}
}
\usage{
data(mortaforest)
}
\description{
The data file contains one row per unique 3.5km grid cell by year
combination. The data frame covers
all grid cells within the state of California where at least one Aerial
Detection Survey (ADS) flight
was taken between 2009 and 2015, so each grid cell position has between
1 and 7 years of data
(reflected as 1 to 7 rows in the data file per grid cell position).
The main response variables
are \code{mort.bin} (presence of any mortality) and \code{mort.tph} (number of dead
trees/ha within the given
grid cell by year).
}
\examples{
data(mortaforest)
head(mortaforest)
}
\references{
\itemize{
\item Young DJN, Stevens JS, Earles JM, Moore J, Ellis A, Jirka AM,
Latimer ML. 2017. Long-term climate and competition explain forest
mortality patterns under extreme drought. Ecology Letters
20(1):78-86. \doi{10.1111/ele.12711}
\item Salas-Eljatib C, Fuentes-Ramírez A, Gregoire TG, Altamirano A,
Yaitul V. A study on the effects of unbalanced data when fitting
logistic regression models in ecology. Ecological Indicators
85:502-508. \doi{10.1016/j.ecolind.2017.10.030}
}
}
\keyword{datasets}
