% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{interpolate}
\alias{interpolate}
\title{Interpolate supplementary points and variables to add to the biplot}
\usage{
interpolate(bp, newdata = NULL, newvariable = NULL)
}
\arguments{
\item{bp}{an object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{newdata}{a new data set, similar in structure to the data set supplied to \code{biplot()}
containing supplementary data points to be added onto the biplot.}

\item{newvariable}{a new data set, similar in structure to the data set supplied to \code{biplot()}
containing supplementary variables to be added onto the biplot.}
}
\value{
The object of class \code{biplot} will be appended with the following elements:
\item{Xnew.raw}{the new data.}
\item{Xnew}{the matrix of the centered and scaled new numeric variables of new data.}
\item{Xnew.cat}{the matrix of the categorical variables of new data.}
\item{Znew}{the matrix of the coordinates of the new data in the biplot.}

For an object of class \code{CA} the following additional elements will be appended:
\item{newrowcoor}{the matrix of row coordinates of the new data in the biplot.}
\item{newcolcoor}{the matrix of column coordinates of the new data in the biplot.}
}
\description{
This function adds supplementary points and variables to the plot from a new data set.
}
\examples{
biplot(data = iris[1:145,]) |> PCA() |> interpolate(newdata = iris[146:150,]) |> plot()
biplot(HairEyeColor[,,2], center = FALSE) |> CA(variant = "Symmetric") |> 
     interpolate(newdata = HairEyeColor[,,1]) |> plot()

}
