% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iccplot.R
\name{iccplot}
\alias{iccplot}
\title{Item Characteristic Curve Plot}
\usage{
iccplot(b, a)
}
\arguments{
\item{b}{a single number representing the value of item difficulty.}

\item{a}{a single number representing the value of item discrimination.}
}
\description{
Plots an item characteristic curve under the two-parameter logistic model.
}
\details{
While the theoretical range of ability is from negative infinity to positive
infinity, practical considerations usually limit the range of values
from -3 to +3.
}
\examples{
iccplot(0, 1)
iccplot(a = 1, b = 0)
iccplot(0, 1); par(new = TRUE); iccplot(-1.5, 1)
}
\references{
Baker, F. B., & Kim, S.-H. (2017).
\emph{The basics of item response theory using R.}
New York, NY: Springer.
ISBN-13: 978-3-319-54204-1
}
\keyword{iccplot}
