% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.bm_matrix.R
\name{as.data.frame.bm_bitmap}
\alias{as.data.frame.bm_bitmap}
\alias{as.data.frame.bm_pixmap}
\title{Convert to data frame with pixel (x,y) coordinates}
\usage{
\method{as.data.frame}{bm_bitmap}(x, ..., filtrate = FALSE)

\method{as.data.frame}{bm_pixmap}(x, ..., filtrate = FALSE)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}} or \code{\link[=bm_pixmap]{bm_pixmap()}} object.}

\item{...}{Currently ignored.}

\item{filtrate}{If \code{FALSE} (default) get coordinates for all values.
If a single value only return the coordinates for pixels that equal that value.}
}
\value{
A data frame with "x", "y", and "value" columns.
}
\description{
\code{as.matrix.bm_matrix()} casts \code{\link[=bm_bitmap]{bm_bitmap()}} objects to a (normal) integer matrix
and \code{\link[=bm_pixmap]{bm_pixmap()}} objects to a (normal) character matrix (of color strings).
}
\examples{
font_file <- system.file("fonts/fixed/4x6.yaff.gz", package = "bittermelon")
font <- read_yaff(font_file)
bm <- as_bm_bitmap("RSTATS", font = font)
df <- as.data.frame(bm, filtrate = 1L)
if (require("grid")) {
  grid.newpage()
  grid.rect(df$x * 0.6, df$y * 0.6, width = 0.5, height = 0.5,
            gp = gpar(fill = 'black'), default.units = 'cm')
}

corn <- farming_crops_16x16()$corn$portrait
df <- as.data.frame(corn)
if (require("grid")) {
  grid.newpage()
  grid.circle(df$x * 0.6, df$y * 0.6, r = 0.25,
              gp = gpar(fill = df$value), default.units = 'cm')
}
}
