% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_compress.R
\name{bm_compress}
\alias{bm_compress}
\alias{bm_compress.bm_bitmap}
\alias{bm_compress.bm_pixmap}
\alias{bm_compress.magick-image}
\alias{bm_compress.nativeRaster}
\alias{bm_compress.raster}
\alias{bm_compress.bm_list}
\title{Compress bitmaps by a factor of two}
\usage{
bm_compress(x, direction = "vertical", ...)

\method{bm_compress}{bm_bitmap}(x, direction = "vertical", ...)

\method{bm_compress}{bm_pixmap}(x, direction = "vertical", ..., filter = "Point")

\method{bm_compress}{`magick-image`}(x, direction = "vertical", ..., filter = "Point")

\method{bm_compress}{nativeRaster}(x, direction = "vertical", ..., filter = "Point")

\method{bm_compress}{raster}(x, direction = "vertical", ..., filter = "Point")

\method{bm_compress}{bm_list}(x, ...)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{direction}{Either "vertical" or "v", "horizontal" or "h",
OR "both" or "b".}

\item{...}{Additional arguments to be passed to or from methods.}

\item{filter}{Passed to \code{\link[magick:transform]{magick::image_resize()}}.
Use \code{\link[magick:options]{magick::filter_types()}} for list of supported filters.
The default "Point" filter will maintain your sprite's color palette.
\code{NULL} will give you the \code{magick}'s default filter which may work better
if you are not trying to maintain a sprite color palette.}
}
\value{
Depending on \code{x} either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{magick-image}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{raster}  object.
}
\description{
Compresses \code{\link[=bm_bitmap]{bm_bitmap()}} objects by a factor of two by re-mapping to a \dQuote{block elements} scheme.
For pixmap objects like \code{\link[=bm_pixmap]{bm_pixmap()}} we simply shrink the pixmap by a factor of two using \code{\link[=bm_distort]{bm_distort()}}.
}
\details{
Depending on \code{direction} we shrink the bitmaps height and/or width by
a factor of two and re-encode pairs/quartets of pixels to a \dQuote{block elements} scheme.
If necessary we pad the right/bottom of the bitmap(s) by
a pixel. For each pair/quartet we determine the most-common non-zero element
and map them to a length twenty set of integers representing the \dQuote{block
elements} scheme.  For integers greater than zero we map it to higher twenty
character sets i.e. \code{1}'s get mapped to 0:19, \code{2}'s get mapped to 20:39, \code{3}'s
get mapped to 40:59, etc.  Using the default \code{px_unicode} will give you the exact
matching \dQuote{Block Elements} glyphs while \code{px_ascii} gives the closest ASCII approximation.
Hence \code{print.bm_bitmap()} should produce reasonable results for compressed bitmaps if
either of them are used as the \code{px} argument.
}
\examples{
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
r <- font[[str2ucp("R")]]
print(r)
print(bm_compress(r, "vertical"))
print(bm_compress(r, "horizontal"))
print(bm_compress(r, "both"))

img <- png::readPNG(system.file("img", "Rlogo.png", package="png"))
logo <- as_bm_pixmap(img)
if (cli::is_utf8_output() && 
    cli::num_ansi_colors() > 256L &&
    requireNamespace("magick", quietly = TRUE)) {
  logo_c <- bm_compress(pm, "both", filter = NULL)
  print(logo_c, compress = "v")
}
}
\seealso{
See \url{https://en.wikipedia.org/wiki/Block_Elements} for more info on the Unicode Block Elements block.
}
