% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blastr.R
\name{fetch_metadata}
\alias{fetch_metadata}
\title{Fetch Metadata (and optionally sequence ranges) from NCBI}
\usage{
fetch_metadata(accessions, db = c("nuccore", "protein"), seq_range = NULL)
}
\arguments{
\item{accessions}{Character vector of accession numbers.}

\item{db}{Either "nuccore" or "protein".}

\item{seq_range}{Either:
\itemize{
\item NULL (default): fetch full sequence for every accession
\item numeric(2):   fetch that same start–end for \emph{all} accessions
\item named list:   each element is a numeric(2) vector, names are accessions;
will fetch only that slice for the named accession,
full sequence for others.
}}
}
\value{
A tibble with columns
\code{accession}, \code{accession_version}, \code{title}, \code{organism}, \code{sequence}
}
\description{
Fetch Metadata (and optionally sequence ranges) from NCBI
}
\examples{
\donttest{
# Fetch metadata for a nucleotide sequence
result <- fetch_metadata("NM_000546", db = "nuccore")

# Fetch specific sequence range (positions 1-100)
result_range <- fetch_metadata("NM_000546", db = "nuccore", seq_range = c(1, 100))

# Fetch multiple accessions
result_multi <- fetch_metadata(c("NM_000546", "NM_001126"), db = "nuccore")
}
}
