% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_image.R
\name{add_image}
\alias{add_image}
\title{Create an HTML fragment for an embedded image}
\usage{
add_image(
  file,
  alt = "",
  width = 520,
  align = c("center", "left", "right", "inline"),
  float = c("none", "left", "right")
)
}
\arguments{
\item{file}{A path to an image file.}

\item{alt}{Text description of image passed to the \code{alt} attribute inside of
the image (\verb{<img>}) tag for use when image loading is disabled and on
screen readers. \code{NULL} default produces blank (\code{""}) alt text.}

\item{width}{The width to be used for the image, in pixels.}

\item{align}{The alignment to be used for the image. If not \code{"inline"}, the
image will appear in its own block, i.e. there will not be text to the left
or right of it.}

\item{float}{The float value to be used for the image. If not \code{"none"}, text
will flow around the image, and the \code{align} argument will be ignored.}
}
\value{
A character object with an HTML fragment that can be placed inside
the message body wherever the image should appear.
}
\description{
Add a local image inside the body of the email with this helper function.
}
\examples{
# Create an HTML fragment that
# contains an image
img_file_path <-
  system.file(
    "example_files",
    "test_image.png",
    package = "blastula"
  )

img_file_html <-
  add_image(file = img_file_path)

# Include the image in the email
# message body by simply referencing
# the `img_file_html` object
email <-
  compose_email(
    body = md(
      c(
"Hello,

Here is an image:\n",
img_file_html
      )
    )
  )

if (interactive()) email

}
