% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_credentials.R
\name{delete_all_credential_keys}
\alias{delete_all_credential_keys}
\title{Delete all \strong{blastula} credential keys}
\usage{
delete_all_credential_keys()
}
\description{
The \code{delete_all_credential_keys()} function deletes all \strong{blastula}
credential keys, giving you a clean slate. Should specific keys need to be
deleted, the \code{\link[=delete_credential_key]{delete_credential_key()}} could be used (one call per credential
key to delete). Before using \code{delete_all_credential_keys()}, it may be useful
to see which keys are available in the key-value store. For that, use the
\code{\link[=view_credential_keys]{view_credential_keys()}} function.
}
\details{
Support for using the \code{delete_all_credential_keys()} function (and for doing
any credential key management) is provided through the \strong{keyring} package.
This function cannot be used without that package being available on the
system. We can use \code{install.packages("keyring")} to install \strong{keyring}.
}
\examples{
# Delete all blastula credential keys
# in the system's key-value store

# delete_all_credential_keys()

}
