% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-block.R
\name{edit_block}
\alias{edit_block}
\alias{edit_block_server}
\alias{edit_block_ui}
\alias{block_summary}
\alias{block_summary.block}
\title{Plugin module for editing board blocks}
\usage{
edit_block(
  server = edit_block_server,
  ui = edit_block_ui,
  validator = abort_not_null
)

edit_block_server(id, block_id, board, update, ...)

edit_block_ui(x, id, ...)

block_summary(x, data)

\method{block_summary}{block}(x, data)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{validator}{Validator function that validates server return values}

\item{id}{Namespace ID}

\item{block_id}{Block ID}

\item{board}{Reactive values object containing board information}

\item{update}{Reactive value object to initiate board updates}

\item{...}{Extra arguments passed from parent scope}

\item{x}{Block}

\item{data}{Result data}
}
\value{
A plugin container inheriting from \code{edit_block} is returned by
\code{edit_block()}, while the UI component (e.g. \code{edit_block_ui()}) is
expected to return shiny UI (i.e. \code{\link[shiny:reexports]{shiny::tagList()}}) and the server
component (i.e. \code{edit_block_server()}) is expected to return \code{NULL}.
}
\description{
Logic and user experience for editing block attributes such as block titles
can be customized or enhanced by providing an alternate version of this
plugin. The default implementation only handles block titles, but if further
(editable) block attributes are to be introduced, corresponding UI and logic
can be included here. In addition to blocks titles, this default
implementation provides UI for removing, as well as inserting blocks before
or after the current one.
}
