% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-links.R
\name{manage_links}
\alias{manage_links}
\alias{manage_links_server}
\alias{manage_links_ui}
\title{Plugin module for managing board links}
\usage{
manage_links(server = manage_links_server, ui = manage_links_ui)

manage_links_server(id, board, update, ...)

manage_links_ui(id, board)
}
\arguments{
\item{server, ui}{Server/UI for the plugin module}

\item{id}{Namespace ID}

\item{board}{The initial \code{board} object}

\item{update}{Reactive value object to initiate board updates}

\item{...}{Extra arguments passed from parent scope}
}
\value{
A plugin container inheriting from \code{manage_links} is returned by
\code{manage_links()}, while the UI component (e.g. \code{manage_links_ui()}) is
expected to return shiny UI (i.e. \code{\link[shiny:reexports]{shiny::tagList()}}) and the server
component (i.e. \code{manage_links_server()}) is expected to return \code{NULL}.
}
\description{
Logic and user experience for adding new, removing and modifying existing
links to/from the board can be customized or enhanced by providing an
alternate version of this plugin. The default implementation provides a
table-based UI, presented in a modal.
}
\details{
Updates are mediated via the \code{\link[shiny:reactiveVal]{shiny::reactiveVal()}} object passed as
\code{update}, where link updates are communicated as list entry \code{stacks} with
components \code{add}, \code{rm} or \code{mod}, where
\itemize{
\item \code{add} is either \code{NULL} or a \code{links} object (link IDs may not already
exists),
\item \code{rm} is either \code{NULL} or a character vector of (existing) link IDs,
\item \code{mod} is either \code{NULL} or a \code{links} object (where link IDs must already
exist).
}
}
