% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list.R
\name{c.sim_list}
\alias{c.sim_list}
\title{Combine multiple sim_list objects into a single one}
\usage{
\method{c}{sim_list}(...)
}
\arguments{
\item{...}{\code{sim_list} and \code{sim} to be concatenated.}
}
\value{
A combined object of class \code{sim_list}.
}
\description{
This function combines the \code{sim_list} and \code{sim} objects use as arguments
in a single \code{sim_list}, provided they are compatible. Compatibility is
defined as in \code{sim_list()}: all spatial interaction models must share
the same costs as well as the same origin and destination data.
}
\examples{
distances <- french_cities_distances[1:15, 1:15] / 1000 ## convert to km
production <- log(french_cities$population[1:15])
attractiveness <- log(french_cities$area[1:15])
all_flows_log <- grid_blvim(
  distances, production, c(1.1, 1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness,
  epsilon = 0.1,
  bipartite = FALSE,
  iter_max = 750
)
production <- rep(1, 15)
attractiveness <- rep(1, 15)
all_flows_unit <- grid_blvim(
  distances, production, c(1.1, 1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness,
  epsilon = 0.1,
  bipartite = FALSE,
  iter_max = 750
)
all_flows <- c(all_flows_log, all_flows_unit)
}
