% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_tree.R
\name{scale_tree}
\alias{scale_tree}
\title{Scale a coancestry tree}
\usage{
scale_tree(tree, factor)
}
\arguments{
\item{tree}{The coancestry tree to edit.}

\item{factor}{The scalar factor to multiply all edges.
Must be non-negative, and not be so large that any edge exceeds 1 after scaling.}
}
\value{
The edited tree with all edges scaled as desired.
}
\description{
Scale by a scalar \code{factor} all the edges (\verb{$edge.length}) of a \code{phylo} object from the \code{ape} package, including the root edge (\verb{$root.edge}) if present, and additive edges (\verb{$edge.length.add}, present in trees returned by \code{\link[=fit_tree]{fit_tree()}}).
Stops if any of the edges exceed 1 before or after scaling (since these edges are IBD probabilities).
}
\examples{
# create a random tree
library(ape)
k <- 5
tree <- rtree( k )

# scale this tree
tree_scaled <- scale_tree( tree, 0.5 )

}
\seealso{
\code{\link[ape:read.tree]{ape::read.tree()}} for reading \code{phylo} objects and their definition.
}
