% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptic_integrals.R
\name{elliptic_integrals}
\alias{elliptic_integrals}
\alias{ellint_rf}
\alias{ellint_rd}
\alias{ellint_rj}
\alias{ellint_rc}
\alias{ellint_rg}
\alias{ellint_1}
\alias{ellint_2}
\alias{ellint_3}
\alias{ellint_d}
\alias{jacobi_zeta}
\alias{heuman_lambda}
\title{Elliptic Integrals}
\usage{
ellint_rf(x, y, z)

ellint_rd(x, y, z)

ellint_rj(x, y, z, p)

ellint_rc(x, y)

ellint_rg(x, y, z)

ellint_1(k, phi = NULL)

ellint_2(k, phi = NULL)

ellint_3(k, n, phi = NULL)

ellint_d(k, phi = NULL)

jacobi_zeta(k, phi)

heuman_lambda(k, phi)
}
\arguments{
\item{x}{First parameter of the integral}

\item{y}{Second parameter of the integral}

\item{z}{Third parameter of the integral}

\item{p}{Fourth parameter of the integral (for Rj)}

\item{k}{Elliptic modulus (for incomplete elliptic integrals)}

\item{phi}{Amplitude (for incomplete elliptic integrals)}

\item{n}{Characteristic (for incomplete elliptic integrals of the third kind)}
}
\value{
A single numeric value with the computed elliptic integral.
}
\description{
Functions to compute various elliptic integrals, including Carlson's elliptic integrals and incomplete elliptic integrals.
}
\examples{
# Carlson's elliptic integral Rf with parameters x = 1, y = 2, z = 3
ellint_rf(1, 2, 3)
#' # Carlson's elliptic integral Rd with parameters x = 1, y = 2, z = 3
ellint_rd(1, 2, 3)
# Carlson's elliptic integral Rj with parameters x = 1, y = 2, z = 3, p = 4
ellint_rj(1, 2, 3, 4)
# Carlson's elliptic integral Rc with parameters x = 1, y = 2
ellint_rc(1, 2)
# Carlson's elliptic integral Rg with parameters x = 1, y = 2, z = 3
ellint_rg(1, 2, 3)
# Incomplete elliptic integral of the first kind with k = 0.5, phi = pi/4
ellint_1(0.5, pi / 4)
# Complete elliptic integral of the first kind
ellint_1(0.5)
# Incomplete elliptic integral of the second kind with k = 0.5, phi = pi/4
ellint_2(0.5, pi / 4)
# Complete elliptic integral of the second kind
ellint_2(0.5)
# Incomplete elliptic integral of the third kind with k = 0.5, n = 0.5, phi = pi/4
ellint_3(0.5, 0.5, pi / 4)
# Complete elliptic integral of the third kind with k = 0.5, n = 0.5
ellint_3(0.5, 0.5)
# Incomplete elliptic integral D with k = 0.5, phi = pi/4
ellint_d(0.5, pi / 4)
# Complete elliptic integral D
ellint_d(0.5)
# Jacobi zeta function with k = 0.5, phi = pi/4
jacobi_zeta(0.5, pi / 4)
# Heuman's lambda function with k = 0.5, phi = pi/4
heuman_lambda(0.5, pi / 4)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/ellint.html}{Boost Documentation} for more details on the mathematical background.
}
