% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vertex_measures.R
\name{plot_vertex_measures}
\alias{plot_vertex_measures}
\title{Plot vertex-level graph measures at a single density or threshold}
\usage{
plot_vertex_measures(g.list, measure, facet.by = NULL,
  group.by = getOption("bg.group"), type = c("violin", "boxplot"),
  show.points = FALSE, ylabel = measure, ...)
}
\arguments{
\item{g.list}{A \code{brainGraphList} or a list of \code{brainGraph} objects}

\item{measure}{A character string of the graph measure to plot}

\item{facet.by}{Character string indicating the variable to facet by (if
any). Default: \code{NULL}}

\item{group.by}{Character string indicating which variable to group the data
by. Default: \code{getOption('bg.group')}}

\item{type}{Character string indicating the plot type. Default:
\code{'violin'}}

\item{show.points}{Logical indicating whether or not to show individual data
points (default: FALSE)}

\item{ylabel}{A character string for the y-axis label}

\item{...}{Arguments passed to \code{geom_boxplot} or \code{geom_violin}}
}
\value{
A \code{trellis} or \code{ggplot} object
}
\description{
Creates boxplots of a single vertex-level graph measure at a single density
or threshold, grouped by the variable specified by \code{group.by} and
optionally faceted by another variable (e.g., \emph{lobe} or \emph{network}).
}
\examples{
\dontrun{
p.deg <- plot_vertex_measures(g[[1]], facet.by='network', measure='degree')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
