% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSets.R
\name{getSets}
\alias{getSets}
\title{Downloads LEGO data from Brickset.}
\usage{
getSets(year, key = getOption("brickset_key"), ...)
}
\arguments{
\item{year}{the year of data to download.}

\item{key}{the Brickset key.}

\item{...}{other parameters passed to \code{\link{getUserHash}} including
the Brickset username and password if they are not available from
\code{getOption('brickset_username')} and \code{getOption('brickset_password')}.}
}
\value{
a data.frame with all sets from the given year.
\describe{
\item{setID}{integer; 20420 unique values}
\item{number}{character; 18958 unique values}
\item{numberVariant}{integer; 25 unique values}
\item{name}{character; 17057 unique values}
\item{year}{integer; 55 unique values}
\item{theme}{character; 163 unique values}
\item{themeGroup}{character; 17 unique values}
\item{subtheme}{character; 1000 unique values}
\item{category}{character; 7 unique values}
\item{released}{logical; 2 unique values}
\item{pieces}{integer; 1543 unique values}
\item{minifigs}{integer; 34 unique values}
\item{bricksetURL}{character; 20420 unique values}
\item{rating}{numeric; 29 unique values}
\item{reviewCount}{integer; 64 unique values}
\item{packagingType}{character; 19 unique values}
\item{availability}{character; 11 unique values}
\item{agerange_min}{integer; 18 unique values}
\item{thumbnailURL}{character; 19365 unique values}
\item{imageURL}{character; 19365 unique values}
\item{US_retailPrice}{numeric; 173 unique values}
\item{US_dateFirstAvailable}{Date; 1090 unique values}
\item{US_dateLastAvailable}{Date; 2324 unique values}
\item{UK_retailPrice}{numeric; 224 unique values}
\item{UK_dateFirstAvailable}{Date; 1019 unique values}
\item{UK_dateLastAvailable}{Date; 2224 unique values}
\item{CA_retailPrice}{numeric; 188 unique values}
\item{CA_dateFirstAvailable}{Date; 851 unique values}
\item{CA_dateLastAvailable}{Date; 2005 unique values}
\item{DE_retailPrice}{numeric; 179 unique values}
\item{DE_dateFirstAvailable}{Date; 607 unique values}
\item{DE_dateLastAvailable}{Date; 1402 unique values}
\item{height}{numeric; 264 unique values}
\item{width}{numeric; 317 unique values}
\item{depth}{numeric; 307 unique values}
\item{weight}{numeric; 1192 unique values}
}
}
\description{
Brickset API documentation is available here:
https://brickset.com/article/52664/api-version-3-documentation/
}
