% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_control.R
\name{control_kr}
\alias{control_kr}
\title{Set controls for Kasim-Raudenbush sampler}
\usage{
control_kr(
  niter = 200L,
  nimp = 0L,
  start = 101L,
  thin = 1L,
  seed = NA_integer_,
  cormodel = c("none", "argyle", "cole"),
  ...
)
}
\arguments{
\item{niter}{Integer. Number of samples from posterior. Default:  \code{200}.}

\item{nimp}{Integer. Number of multiple imputations. Default: \code{0}.}

\item{start}{Integer. The iteration number of the first observation}

\item{thin}{Integer. The thinning interval between consecutive observations}

\item{seed}{Integer. Seed number for \code{\link[base:Random]{base::set.seed()}}. Use \code{NA} to
bypass seed setting.}

\item{cormodel}{String indicating the correlation model:
\code{"none"} (default), \code{"argyle"} or \code{"cole"}}

\item{\dots}{Allow for dot parameters}
}
\value{
A list with eight components. The function calculates parameters
\code{end} (the iteration number of the last iteration) and \code{thin_imp}
(thinning factor for multiple imputations) from the other inputs.
}
\description{
Set controls for Kasim-Raudenbush sampler
}
