% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_card}
\alias{bs_card}
\title{Create a Bootstrap card}
\usage{
bs_card(
  header = NULL,
  title = NULL,
  text = NULL,
  body,
  footer = NULL,
  img_src = NULL,
  img_alt = NULL,
  div_attr = c(class = "card"),
  header_attr = c(class = "card-header"),
  title_attr = c(class = "card-title"),
  text_attr = c(class = "card-text"),
  body_attr = c(class = "card-body"),
  footer_attr = c(class = "card-footer"),
  img_attr = c(class = "card-img-top"),
  header_func = h5,
  title_func = h5,
  text_func = h5,
  img_left = FALSE,
  img_right = FALSE,
  img_col_attr = c(class = "col-md-6"),
  body_col_attr = c(class = "col-md-6"),
  img_horizontal_attr = c(class = "img-fluid")
)
}
\arguments{
\item{header}{A string, the HTML to display in the header of the card.}

\item{title}{A string, the HTML to display in the title of the card.}

\item{text}{A string, the HTML to display in the text of the card.}

\item{body}{A string, the HTML to display in the body of the card.}

\item{footer}{A string, the HTML to display in the footer of the card.}

\item{img_src}{A string, the path of an image to display with the card. Passed to "src" attribute of the <img> tag.}

\item{img_alt}{A string, the alt attribute of an image to display with the card. Passed to "alt" attribute of the <img> tag.}

\item{div_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the card content.}

\item{header_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the card header.}

\item{title_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the card title.}

\item{text_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the card text.}

\item{body_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the card body.}

\item{footer_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the card footer.}

\item{img_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the img tag if an image is to be displayed.}

\item{header_func}{A html5 function to use for the header input.}

\item{title_func}{A html5 function to use for the title input.}

\item{text_func}{A html5 function to use for the text input.}

\item{img_left}{TRUE/FALSE, if TRUE, places the image on the left of the card}

\item{img_right}{TRUE/FALSE, if TRUE, places the image on the right of the card}

\item{img_col_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the column containing the img tag if an image is to be displayed horizontally.}

\item{body_col_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the column containing the body if an image is to be displayed horizontally.}

\item{img_horizontal_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the img tag if an image is to be displayed horizontally.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/components/card/}.
}
\examples{
bs_card(
body = "This is a card"
)
}
