% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsTools2.R
\name{bs_dropdown}
\alias{bs_dropdown}
\title{Create a Bootstrap dropdown}
\usage{
bs_dropdown(
  id,
  items = list(),
  button_label = "Dropdown Button",
  dropdown_attr = c(class = "dropdown"),
  button_attr = c(class = "btn btn-secondary dropdown-toggle"),
  ul_attr = c(class = "dropdown-menu"),
  li_attr = NULL,
  a_attr = c(class = "dropdown-item")
)
}
\arguments{
\item{id}{A string, the id to use for the dropdown, must be unique within a page (if you have multiple dropdowns on a page).}

\item{items}{A named list, names become the href for each item, values should be the text to display for each href. If an item is
unnamed, the value does not get passed to the li/a tags and is instead displayed as-is (useful for displaying custom HTML content in the
dropdown).}

\item{button_label}{A string, the label to use for the dropdown toggle button.}

\item{dropdown_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the div wrapping the dropdown elements.}

\item{button_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the button controlling the dropdown toggle.}

\item{ul_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the "ul" tag wrapping the dropdown nav elements.}

\item{li_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the "li" tags wrapping the dropdown nav elements if the input list item is named.}

\item{a_attr}{A named list or named vector, names are attribute names and values are attribute values. Added to the "a" tags wrapping the dropdown nav elements if the input list item is named.}
}
\value{
A string of HTML.
}
\description{
Learn more at \url{https://getbootstrap.com/docs/5.1/components/dropdowns/}.
}
\examples{
bs_dropdown(
id = "drop",
items = list(
  "#" = "Home",
  "#" = "About",
  "#" = "Other"
)
)
}
