# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title constituerGrappes
#' @name constituerGrappes
#' @description 
#'   Quadtree variant function. 
#'   
#'   (Variante de la fonction Quadtree.)
#' @usage constituerGrappes(iNbObsMin, mEffectifs)
#' @param iNbObsMin 
#'   - An \code{integer} representing the minimum number of elements in each cluster
#'   - Un \code{data.frame} représentant le nombre minimum d'éléments dans chaque grappe.)
#' @param mEffectifs
#'   - staffing matrix for each cell (\code{matrix}). 
#'   - matrice des effectifs pour chaque case (\code{matrix}). .)
#' @return
#'   - Returns a \code{matrix} with the cluster number for each cell . 
#'   - Retourne une \code{matrix} avec le numéro de grappe pour chaque cellule.
#' @author
#'   - Psar Analyse Urbaine Insee 
#'   - Arlindo Dos Santos
#'   - Francois Semecurbe
NULL

constituerGrappes <- function(iNbObsMin, mEffectifs) {
    .Call('_btb_constituerGrappes', PACKAGE = 'btb', iNbObsMin, mEffectifs)
}

coordonneesGrappe <- function(iNiveauMax, iNoGrappe) {
    .Call('_btb_coordonneesGrappe', PACKAGE = 'btb', iNiveauMax, iNoGrappe)
}

#' @title constituerMatriceEffectifs
#' @name constituerMatriceEffectifs
#' @description 
#' Function constituting a membership matrix (Fonction constituant une matrice des effectifs)
#' @usage constituerMatriceEffectifs(vLigneObservation, vColonneObservation)
#'
#' @param vLigneObservation : 
#'  - A \code{vector} containing the line number of each observation
#'  - (Un \code{vector} contenant le numéro de ligne de chaque observation.)
#' @param  vColonneObservation : 
#'   - A \code{vector} containing the column number of each observation
#'   - (Un \code{vector} contenant le numéro de colonne de chaque observation.)
#' @return 
#'  Returns a \code{matrix} with the number of observations for each cell.
#'  
#'  (Retourne une \code{matrix} avec le nombre d'observations pour chaque cellule.)
#'
#' @author
#'    - Psar Analyse Urbaine Insee 
#'    - Arlindo Dos Santos 
#'    - Francois Semecurbe
#'
NULL

constituerMatriceEffectifs <- function(vLigneObservation, vColonneObservation) {
    .Call('_btb_constituerMatriceEffectifs', PACKAGE = 'btb', vLigneObservation, vColonneObservation)
}

calculeQuantiles <- function(vModalites, vPonderation, vQuantiles) {
    .Call('_btb_calculeQuantiles', PACKAGE = 'btb', vModalites, vPonderation, vQuantiles)
}

rcppLissageMedian <- function(vXobservations, vYobservations, iRayon, mVar, vXCentroides, vYCentroides, vQuantiles) {
    .Call('_btb_rcppLissageMedian', PACKAGE = 'btb', vXobservations, vYobservations, iRayon, mVar, vXCentroides, vYCentroides, vQuantiles)
}

rcppLissage <- function(vXObservation, vYObservation, vLigneObservation, vColonneObservation, iPas, iRayon, iNeighbor, mVariables, iNumberCols, iNumberRows, iMinXCentroide, iMinYCentroide, mIcentroide, iNbCentroides, updateProgress = NULL) {
    .Call('_btb_rcppLissage', PACKAGE = 'btb', vXObservation, vYObservation, vLigneObservation, vColonneObservation, iPas, iRayon, iNeighbor, mVariables, iNumberCols, iNumberRows, iMinXCentroide, iMinYCentroide, mIcentroide, iNbCentroides, updateProgress)
}

rcppLissageMedianGrappe <- function(iMinObsGrappe, vXObservation, vYObservation, vLigneObservation, vColonneObservation, iPas, iRayon, mVariables, vXCentroide, vYCentroide, vLigneCentroide, vColonneCentroide, vQuantile) {
    .Call('_btb_rcppLissageMedianGrappe', PACKAGE = 'btb', iMinObsGrappe, vXObservation, vYObservation, vLigneObservation, vColonneObservation, iPas, iRayon, mVariables, vXCentroide, vYCentroide, vLigneCentroide, vColonneCentroide, vQuantile)
}

