% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-process.R
\name{sim_mnormal}
\alias{sim_mnormal}
\title{Generate Multivariate Normal Random Vector}
\usage{
sim_mnormal(
  num_sim,
  mu = rep(0, 5),
  sig = diag(5),
  method = c("eigen", "chol")
)
}
\arguments{
\item{num_sim}{Number to generate process}

\item{mu}{Mean vector}

\item{sig}{Variance matrix}

\item{method}{Method to compute \eqn{\Sigma^{1/2}}.
Choose between \code{eigen} (spectral decomposition) and \code{chol} (cholesky decomposition).
By default, \code{eigen}.}
}
\value{
T x k matrix
}
\description{
This function samples n x muti-dimensional normal random matrix.
}
\details{
Consider \eqn{x_1, \ldots, x_n \sim N_m (\mu, \Sigma)}.
\enumerate{
\item Lower triangular Cholesky decomposition: \eqn{\Sigma = L L^T}
\item Standard normal generation: \eqn{Z_{i1}, Z_{in} \stackrel{iid}{\sim} N(0, 1)}
\item \eqn{Z_i = (Z_{i1}, \ldots, Z_{in})^T}
\item \eqn{X_i = L Z_i + \mu}
}
}
