% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vharlse.R, R/print-vharlse.R, R/criteria.R,
%   R/member.R
\name{vhar_lm}
\alias{vhar_lm}
\alias{print.vharlse}
\alias{logLik.vharlse}
\alias{AIC.vharlse}
\alias{BIC.vharlse}
\alias{is.vharlse}
\alias{knit_print.vharlse}
\title{Fitting Vector Heterogeneous Autoregressive Model}
\usage{
vhar_lm(
  y,
  har = c(5, 22),
  exogen = NULL,
  s = 0,
  include_mean = TRUE,
  method = c("nor", "chol", "qr")
)

\method{print}{vharlse}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{logLik}{vharlse}(object, ...)

\method{AIC}{vharlse}(object, ...)

\method{BIC}{vharlse}(object, ...)

is.vharlse(x)

\method{knit_print}{vharlse}(x, ...)
}
\arguments{
\item{y}{Time series data of which columns indicate the variables}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}

\item{exogen}{Exogenous variables}

\item{s}{Lag of exogeneous variables in VHARX. By default, \code{s = 0}.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{method}{Method to solve linear equation system.
(\code{nor}: normal equation (default), \code{chol}: Cholesky, and \code{qr}: HouseholderQR)}

\item{x}{Any object}

\item{digits}{digit option to print}

\item{...}{not used}

\item{object}{A \code{vharlse} object}
}
\value{
\code{vhar_lm()} returns an object named \code{vharlse} \link{class}.
It is a list with the following components:

\describe{
\item{coefficients}{Coefficient Matrix}
\item{fitted.values}{Fitted response values}
\item{residuals}{Residuals}
\item{covmat}{LS estimate for covariance matrix}
\item{df}{Numer of Coefficients}
\item{m}{Dimension of the data}
\item{obs}{Sample size used when training = \code{totobs} - \code{month}}
\item{y0}{Multivariate response matrix}
\item{p}{3 (The number of terms. \code{vharlse} contains this element for usage in other functions.)}
\item{week}{Order for weekly term}
\item{month}{Order for monthly term}
\item{totobs}{Total number of the observation}
\item{process}{Process: VHAR}
\item{type}{include constant term (\code{const}) or not (\code{none})}
\item{HARtrans}{VHAR linear transformation matrix}
\item{design}{Design matrix of VAR(\code{month})}
\item{y}{Raw input}
\item{method}{Solving method}
\item{call}{Matched call}
}
It is also a \code{bvharmod} class.
}
\description{
This function fits VHAR using OLS method.
}
\details{
For VHAR model

\deqn{Y_{t} = \Phi^{(d)} Y_{t - 1} + \Phi^{(w)} Y_{t - 1}^{(w)} + \Phi^{(m)} Y_{t - 1}^{(m)} + \epsilon_t}

the function gives basic values.
}
\examples{
# Perform the function using etf_vix dataset
fit <- vhar_lm(y = etf_vix)
class(fit)
str(fit)

# Extract coef, fitted values, and residuals
coef(fit)
head(residuals(fit))
head(fitted(fit))
}
\references{
Baek, C. and Park, M. (2021). \emph{Sparse vector heterogeneous autoregressive modeling for realized volatility}. J. Korean Stat. Soc. 50, 495-510.

Bubák, V., Kočenda, E., & Žikeš, F. (2011). \emph{Volatility transmission in emerging European foreign exchange markets}. Journal of Banking & Finance, 35(11), 2829-2841.

Corsi, F. (2008). \emph{A Simple Approximate Long-Memory Model of Realized Volatility}. Journal of Financial Econometrics, 7(2), 174-196.
}
\seealso{
\itemize{
\item \code{\link[=coef.vharlse]{coef.vharlse()}}, \code{\link[=residuals.vharlse]{residuals.vharlse()}}, and \code{\link[=fitted.vharlse]{fitted.vharlse()}}
\item \code{\link[=summary.vharlse]{summary.vharlse()}} to summarize VHAR model
}
}
