% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogramR.R
\name{cartogramR}
\alias{cartogramR}
\title{Make a continuous cartogram (density equalizing maps)}
\usage{
cartogramR(
  data,
  count,
  method = c("gsm", "gn", "dcn", "GastnerSeguyMore", "GastnerNewman",
    "DougenikChrismanNiemeyer"),
  options = NULL
)
}
\arguments{
\item{data}{a sf object which contains at least two columns:
obviously a geometry column (giving the map) and a column which
contains a count by region (leading to a density by region,
density to be equalized by deformation). Each row of \code{data} is a region and
contains the simple feature geometry of type \code{POLYGON} or
\code{MULTIPOLYGON}. Polygon ring directions are not checked but
exterior ring must counter clockwise and holes clockwise (use
option \code{check_ring_dir} of \link[sf:st_read]{sf::st_read} to achieve the right
orientation of ring direction on import or use \link{check_ring_dir}
function)}

\item{count}{a character string which indicates the name of the
column (in \code{data} object) which contains the count by
region.}

\item{method}{the method to be used, can be one of the following:
\code{gsm} or \code{GastnerSeguyMore} (default), \code{gn} or
\code{GastnerNewman}, \code{dcn} or \code{DougenikChrismanNiemeyer}.}

\item{options}{a named list given to \link{cartogramR_options} function
which process options see \link{cartogramR_options} for
details. Default to \code{NULL}.}
}
\value{
A cartogramR object: a list with the following components:
\itemize{
\item cartogram: a sf object (in the same order of \code{data} or sorted by \code{idregion}
see reordered argument) which contains the initial data
(without the geometry) with  three additionnal columns (orig_area: original
areas of regions, final_area: final areas of regions in the cartogram
and target_areas the targeted area) and a geometry part which is
the cartogram (ie the initial polygons after deformation)
\item orig_centers: the initial centers calculated with \link[sf:geos_unary]{sf::st_point_on_surface}
\item final_centers: the centers after deformation
\item gridx: (for flow-based method) final grid (x-axis) if requested
(see \link{cartogramR_options} for details).
\item gridy: (for flow-based method) final grid (y-axis) if requested
(see \link{cartogramR_options} for details).
with additionnal attributes.
}
}
\description{
Make a continuous cartogram (density equalizing maps)
}
\examples{
\donttest{
  data(usa)
  carto <- cartogramR(usa, "electors64")
  plot(carto)
  summary(carto)
}

}
\references{
\itemize{
\item Dougenik, J., Chrisman, R. &  Niemeyer, D. (1985).
An algorithm to construct continuous area cartograms.
Professional Geographer \strong{37}: 75-81.
\item Gastner, M. & Newman, M.E.J. (2004). Diffusion-based
method for producing density equalizing
maps. \emph{Proc. Natl. Acad. Sci. USA}, \strong{101}:7499-7504
\item Gastner, M., Seguy, V. & More, P. (2018). Fast flow-based
algorithm for creating density-equalizing map
projections. \emph{Proceedings of the National Academy of Sciences
USA}, \strong{115}:E2156-E2164, website:
\href{https://go-cart.io/}{go-cart}
}
}
