% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnel.R
\name{catmap.funnel}
\alias{catmap.funnel}
\title{catmap: Funnel Plot}
\usage{
catmap.funnel(catmapobject, funnel = FALSE)
}
\arguments{
\item{catmapobject}{A catmap object created by \code{\link{catmap}}.}

\item{funnel}{A boolean. Toggles whether the funnel plot should get saved
to the current working directory.}
}
\description{
The \code{catmap.funnel} creates a funnel plot of the individual Log Odds Ratio
 against the standard error of the Log Odds Ratio. The vertical line indicates
 the combined Log Odds Ratio. Per the \code{metafor} package, "A pseudo
 confidence interval region is drawn around this value with bounds equal
 to +/- 1.96 SE".
}
\examples{
data(catmapdata)
catmapobject <- catmap(catmapdata, 0.95, TRUE)
catmap.funnel(catmapobject, TRUE)
}
\seealso{
\code{\link{catmap}}, \code{\link{catmap.forest}},
 \code{\link{catmap.sense}}, \code{\link{catmap.cumulative}},
 \code{\link{catmap.funnel}}
}
\author{
Algorithm designed and implemented by Kristin K. Nicodemus.
 Code modified and updated by Thom Quinn.
}
