% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combat_helpers.R
\name{cb.correct.apply_cComBat}
\alias{cb.correct.apply_cComBat}
\title{Adjust for batch effects using an empirical Bayes framework}
\usage{
cb.correct.apply_cComBat(Ys, Ts, Xs, Model)
}
\arguments{
\item{Ys}{an \code{[n, d]} matrix, for the outcome variables with \code{n} samples in \code{d} dimensions.}

\item{Ts}{\code{[n]} the labels of the samples, with \code{K < n} levels, as a factor variable.}

\item{Xs}{\code{[n, r]} the \code{r} covariates/confounding variables, for each of the \code{n} samples, as a data frame with named columns.}

\item{Model}{a list containing the following parameters:
\itemize{
   \item{\code{Var}} the pooled variance
   \item{\code{Grand.mean}} the overall mean of the data
   \item{\code{B.hat}} the fit regression coefficients
   \item{\code{Gamma}} additive batch effects
   \item{\code{Delta}} multiplicative batch effects
   \item{\code{Levels}} the order of levels for each batch
   \item{\code{Covar.Mod}} the covariate model for adjustment
}
This model is output after fitting with \code{\link{cb.correct.matching_cComBat}}.}
}
\value{
an \code{[n, d]} matrix, the batch-effect corrected data.
}
\description{
ComBat allows users to adjust for batch effects in datasets where the batch covariate is known, using methodology
described in Johnson et al. 2007. It uses either parametric or non-parametric empirical Bayes frameworks for adjusting data for
batch effects.  Users are returned an expression matrix that has been corrected for batch effects. The input
data are assumed to be cleaned and normalized before batch effect removal.
}
\details{
Note: this code is adapted directly from the \code{\link[sva]{ComBat}} algorithm featured in the `sva` package.
}
\examples{
library(causalBatch)
sim <- cb.sims.sim_linear(a=-1, n=200, err=1/8, unbalancedness=3)
# fit batch effect correction for first 100 samples
cb.fit <- cb.correct.matching_cComBat(sim$Ys[1:100,,drop=FALSE], sim$Ts[1:100], 
                                  data.frame(Covar=sim$Xs[1:100,,drop=FALSE]), "Covar")
# apply to all samples
cor.dat <- cb.correct.apply_cComBat(sim$Ys, sim$Ts, data.frame(Covar=sim$Xs), cb.fit$Model)

}
