% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sims.R
\name{cb.sims.sim_linear}
\alias{cb.sims.sim_linear}
\title{Linear Simulation}
\usage{
cb.sims.sim_linear(
  n = 100,
  pi = 0.5,
  eff_sz = 1,
  alpha = 2,
  unbalancedness = 1,
  err = 1/2,
  null = FALSE,
  a = -2,
  b = -1,
  nbreaks = 200
)
}
\arguments{
\item{n}{the number of samples. Defaults to \code{100}.}

\item{pi}{the balance between the classes, where samples will be from group 1
with probability \code{pi}, and group 2 with probability \code{1 - pi}. Defaults
to \code{0.5}.}

\item{eff_sz}{the treatment effect between the different groups. Defaults to \code{1}.}

\item{alpha}{the alpha for the covariate sampling procedure. Defaults to \code{2}.}

\item{unbalancedness}{the level of covariate dissimilarity between the covariates
for each of the groups. Defaults to \code{1}.}

\item{err}{the level of noise for the simulation. Defaults to \code{1/2}.}

\item{null}{whether to generate a null simulation. Defaults to \code{FALSE}. Same behavior can be achieved by setting \code{eff_sz = 0}.}

\item{a}{the first parameter for the covariate/outcome relationship. Defaults to \code{-2}.}

\item{b}{the second parameter for the covariate/outcome relationship. Defaults to \code{-1}.}

\item{nbreaks}{the number of breakpoints for computing the expected outcome at a given covariate level
for each batch. Defaults to \code{200}.}
}
\value{
a list, containing the following:
\item{Ys}{an \code{[n, 2]} matrix, containing the outcomes for each sample. The first dimension contains the "treatment effect".}
\item{Ts}{an \code{[n, 1]} matrix, containing the group/batch labels for each sample.}
\item{Xs}{an \code{[n, 1]} matrix, containing the covariate values for each sample.}
\item{Eps}{an \code{[n, 1]} matrix, containing the error for each sample.}
\item{x.bounds}{the theoretical bounds for the covariate values.}
\item{Ytrue}{an \code{[nbreaks*2, 2]} matrix, containing the expected outcomes at a covariate level indicated by \code{Xtrue}.}
\item{Ttrue}{an \code{[nbreaks*2,1]} matrix, indicating the group/batch the expected outcomes and covariate breakpoints correspond to.}
\item{Xtrue}{an \code{[nbreaks*2, 1]} matrix, indicating the values of the covariate breakpoints for the theoretical expected outcome in \code{Ytrue}.}
\item{Effect}{The batch effect magnitude.}
\item{Overlap}{the theoretical degree of overlap between the covariate distributions for each of the two groups/batches.}
\item{oracle_fn}{A function for fitting outcomes given covariates.}
}
\description{
Linear Simulation
}
\section{Details}{


A linear relationship between the covariate and the outcome. The first dimension of the outcome is:
\deqn{Y_i = a\times (X_i + b) - \text{eff\_sz} \times T_i + \frac{1}{2} \epsilon_i}

where the batch/group labels are:
\deqn{T_i \overset{iid}{\sim} Bern(\pi)}

The beta coefficient for the covariate sampling is:
\deqn{\beta = \alpha \times \text{unbalancedness}}
The covariate values for the first batch are:
\deqn{X_i | T_i = 0 \overset{ind}{\sim} 2 Beta(\alpha, \beta) - 1}
and the covariate values for the second batch are:
\deqn{X_i | T_i = 1 \overset{ind}{\sim} 2 Beta(\beta, \alpha) - 1}
Finally, the error terms are:
\deqn{\epsilon_i \overset{iid}{\sim} Norm(0, \text{err}^2)}

For more details see the help vignette:
\code{vignette("causal_simulations", package = "causalBatch")}
}

\examples{

library(causalBatch)
sim = cb.sims.sim_linear()

}
\references{
Eric W. Bridgeford, et al. "A Causal Perspective for Batch Effects: When is no answer better than a wrong answer?" Biorxiv (2024).
}
\author{
Eric W. Bridgeford
}
