#' Inverse cumulative distribution function for chi-square distribution
#'
#' Computes the value of sample variance corresponding to the input quantile p of the chi-square distribution for n-1 degrees of freedom
#'
#' Do not call qnormvar() directly.
#' Pass DISTR="normvar" to cdfinv() when computing intervals for the
#' normal variance.
#' The parameter name to be passed to cdfinv() is sigma2.
#' The additional argument n (sample size) is to be passed to cdfinv().
#'
#' @param p the cdf value (named in accordance with R standards)
#' @param sigma2 the assumed normal variance
#' @param n the sample size (pass this as an extra argument to cdfinv())
#'
#' @returns The value of sample variance corresponding to the input quantile p of the chi-square distribution for n-1 degrees of freedom
#'
#' @author Peter E. Freeman, \email{pfreeman@@cmu.edu}
#'
qnormvar <- function(p,sigma2,n)
{
  if ( n == 1 ) stop("At least two observations are required for normal variance confidence intervals.")
  qchisq(p,n-1)*sigma2/(n-1) 
}
