% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_susceptibility.R
\name{calc_susceptibility}
\alias{calc_susceptibility}
\title{Calculate cDIV threshold for sugar beet cultivars}
\usage{
calc_susceptibility(var_scale = 4)
}
\arguments{
\item{var_scale}{numeric, bsa scale (1-9) of the sugar beet cultivars.
1 is the lowest susceptibility and 9 is the highest susceptibility.
See https://www.bundessortenamt.de and Wolf and Verreet (2005) Table 1.}
}
\value{
numeric, cDIV threshold for the start of the epidemic
}
\description{
This function was written using summary data from Wolf and Verreet (2005),
Table 1 and Table 2 to determine the equivalent cumulative daily infection
value where epidemic onset begins. The average difference between 'high' and
'low' susceptible cultivars was 1.2 on the variety scale. The average
difference between low and highly susceptible cultivars minimum cDIV on each
starting time in Table 2 was 4.637.
}
