% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{CI.regression}
\alias{CI.regression}
\title{Confidence interval construction of change points for regression settings with change points.}
\usage{
CI.regression(
  cpt_init,
  cpt_LR,
  beta_hat,
  y,
  X,
  w = 0.9,
  B = 1000,
  M,
  alpha_vec,
  rounding = TRUE
)
}
\arguments{
\item{cpt_init}{An \code{integer} vector of initial changepoints estimation (sorted in strictly increasing order).}

\item{cpt_LR}{An \code{integer} vector of refined changepoints estimation (sorted in strictly increasing order).}

\item{beta_hat}{A \code{numeric} (px(K_hat+1))matrix of estimated regression coefficients.}

\item{y}{A \code{numeric} vector of response variable.}

\item{X}{A \code{numeric} matrix of covariates with vertical axis being time.}

\item{w}{A \code{numeric} scalar in (0,1) representing the weight for interval truncation.}

\item{B}{An \code{integer} scalar corresponding to the number of simulated two-sided Brownian motion with drift.}

\item{M}{An \code{integer} scalar corresponding to the length for each side of the limiting distribution, i.e. the two-sided Brownian motion with drift.}

\item{alpha_vec}{An \code{numeric} vector in (0,1) representing the vector of significance levels.}

\item{rounding}{A \code{boolean} scalar representing if the confidence intervals need to be rounded into integer intervals.}
}
\value{
An length(cpt_init)-2-length(alpha_vec) array of confidence intervals.
}
\description{
Construct element-wise confidence interval for change points.
}
\examples{
d0 = 5
p = 10
n = 200
cpt_true = c(70, 140)
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
lambda_set = c(0.1, 0.5, 1, 2)
zeta_set = c(10, 15, 20)
temp = CV.search.DPDU.regression(y = data$y, X = data$X, lambda_set, zeta_set)
temp$test_error # test error result
# find the indices of lambda_set and zeta_set which minimizes the test error
min_idx = as.vector(arrayInd(which.min(temp$test_error), dim(temp$test_error))) 
lambda_set[min_idx[2]]
zeta_set[min_idx[1]]
cpt_init = unlist(temp$cpt_hat[min_idx[1], min_idx[2]])
beta_hat = matrix(unlist(temp$beta_hat[min_idx[1], min_idx[2]]), ncol = length(cpt_init)+1)
cpt_LR = local.refine.DPDU.regression(cpt_init, beta_hat, data$y, data$X, w = 0.9)
alpha_vec = c(0.01, 0.05, 0.1)
CI.regression(cpt_init, cpt_LR, beta_hat, data$y, data$X, w = 0.9, B = 1000, M = n, alpha_vec)
}
\references{
Xu, Wang, Zhao and Yu (2022) <arXiv:2207.12453>.

Xu, Wang, Zhao and Yu (2022) <arXiv:2207.12453>.
}
\author{
Haotian Xu
}
