% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{DPDU.regression}
\alias{DPDU.regression}
\title{Dynamic programming with dynamic update algorithm for regression change points localisation with \eqn{l_0} penalisation.}
\usage{
DPDU.regression(y, X, lambda, zeta, eps = 0.001)
}
\arguments{
\item{y}{A \code{numeric} vector of response variable.}

\item{X}{A \code{numeric} matrix of covariates with vertical axis being time.}

\item{lambda}{A positive \code{numeric} scalar of tuning parameter for lasso penalty.}

\item{zeta}{A positive \code{integer} scalar of tuning parameter associated with \eqn{l_0} penalty (minimum interval size).}

\item{eps}{A \code{numeric} scalar of precision level for convergence of lasso.}
}
\value{
An object of \code{\link[base]{class}} "DP", which is a \code{list} with the following structure:
 \item{partition}{A vector of the best partition.}
 \item{cpt}{A vector of change points estimation.}
}
\description{
Perform DPDU algorithm for regression change points localisation.
}
\examples{
d0 = 10
p = 20
n = 100
cpt_true = c(30, 70)
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
temp = DPDU.regression(y = data$y, X = data$X, lambda = 1, zeta = 20)
cpt_hat = temp$cpt
}
\references{
Xu, Wang, Zhao and Yu (2022) <arXiv:2207.12453>.
}
\author{
Haotian Xu
}
