% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_polynomial.R
\name{gen.piece.poly}
\alias{gen.piece.poly}
\title{Generate univariate data from piecewise polynomials of degree at most r.}
\usage{
gen.piece.poly(init_coef_vec, cpt_vec, kappa_mat, n, sigma)
}
\arguments{
\item{init_coef_vec}{A (r+1)-dim \code{numeric} vector of coefficients for the first segment.}

\item{cpt_vec}{A K-dim \code{integer} vector of change points.}

\item{kappa_mat}{A (r+1)xK \code{numeric} matrix where the i-th column represents the jump sizes for coefficients associated with the i-th change point.}

\item{n}{An \code{integer} scalar of sample size.}

\item{sigma}{A \code{numeric} scalar of standard deviation of error terms.}
}
\value{
A vector of data generated from piecewise polynomials.
}
\description{
Generate univariate data from piecewise polynomials (currently, only the linear, quadratic functions and cubic functions are considered).
}
\examples{
r = 2
init_coef_vec = c(-2, 2, 9)
cpt_true = c(100, 200)
n = 300
sigma = 1
kappa_mat = cbind(c(3, 9, -27), c(-3, 9, -27))
plot.ts(gen.piece.poly(init_coef_vec, cpt_true, kappa_mat, n, sigma), ylab = "y")
}
\references{
Yu and Chatterjee (2020) <arXiv:2007.09910>.
}
\author{
Haotian Xu
}
