% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{simu.SBM}
\alias{simu.SBM}
\title{Simulate a Stochastic Block Model (without change point).}
\usage{
simu.SBM(connec_mat, can_vec, n, symm = FALSE, self = TRUE)
}
\arguments{
\item{connec_mat}{A \code{numeric} symmetric matrix representing the connectivity matrix (each entry takes value in \eqn{[0,1]}).}

\item{can_vec}{A \code{integer} p-dim vector of node indices. can_vec is then divided into subvectors corresponding to blocks.}

\item{n}{A \code{integer} scalar representing the number of observations.}

\item{symm}{A \code{logic} scalar indicating if adjacency matrices are required to be symmetric.}

\item{self}{A \code{logic} scalar indicating if adjacency matrices are required to have self-loop.}
}
\value{
A \code{list} with the following structure:
 \item{obs_mat}{A matrix, with each column be the vectorized adjacency (sub)matrix. For example, if "symm = TRUE" and "self = FALSE", only the strictly lower triangular matrix is considered.}
 \item{graphon_mat}{Underlying graphon matrix.}
}
\description{
Simulate a Stochastic Block Model (without change point). The generated data is a matrix with each column corresponding to the vectorized adjacency (sub)matrix at a time point. For example, if the network matrix is required to be symmetric and without self-loop, only the strictly lower diagonal entries are considered.
}
\examples{
p = 15 # number of nodes
rho = 0.5 # sparsity parameter
block_num = 3 # number of groups for SBM
n = 100 # sample size for each segment
# connectivity matrix for the first and the third segments
conn1_mat = rho * matrix(c(0.6,1,0.6,1,0.6,0.5,0.6,0.5,0.6), nrow = 3) 
# connectivity matrix for the second segment
conn2_mat = rho * matrix(c(0.6,0.5,0.6,0.5,0.6,1,0.6,1,0.6), nrow = 3) 
set.seed(1)
can_vec = sample(1:p, replace = FALSE) # randomly assign nodes into groups
sbm1 = simu.SBM(conn1_mat, can_vec, n, symm = TRUE, self = TRUE)
sbm2 = simu.SBM(conn2_mat, can_vec, n, symm = TRUE, self = TRUE)
data_mat = cbind(sbm1$obs_mat, sbm2$obs_mat)
}
\references{
Wang, Yu and Rinaldo (2018) <arxiv:1809.09602>.
}
\author{
Daren Wang & Haotian Xu
}
