% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDPG.R
\name{tuneBSnonparRDPG}
\alias{tuneBSnonparRDPG}
\title{Change points detection for dependent dynamic random dot product graph models.}
\usage{
tuneBSnonparRDPG(BS_object, data_mat, lowerdiag = FALSE, d)
}
\arguments{
\item{BS_object}{A "BS" object produced by \code{WBS.nonpar.RDPG}.}

\item{data_mat}{A \code{numeric} matrix of observations with horizontal axis being time, and vertical axis being vectorized adjacency matrix.}

\item{lowerdiag}{A \code{logic} scalar. TRUE, if each row of data_mat is the vectorization of the strictly lower diagonal elements in an adjacency matrix. FALSE, if each row of data_mat is the vectorization of all elements in an adjacency matrix.}

\item{d}{A \code{numeric} scalar of the number of leading singular values of an adjacency matrix considered in the scaled PCA algorithm.}
}
\value{
A \code{numeric} vector of estimated change points.
}
\description{
Perform Change points detection for dependent dynamic random dot product graph models. The tuning parameter tau for WBS is automatically selected based on the BIC-type scores defined in Equation (2.4) in Zou et al. (2014).
}
\examples{
### generate data 
p = 20 # number of nodes
n = 50 # sample size for each segment
lat_dim_num = 5 # number of latent dimensions
set.seed(1)
x_mat = matrix(runif(p*lat_dim_num), nrow = p, ncol = lat_dim_num)
x_tilde_mat = matrix(runif(p*lat_dim_num), nrow = p, ncol = lat_dim_num)
y_mat = rbind(x_tilde_mat[1:floor(p/4),], x_mat[(floor(p/4)+1):p,])
rdpg1 = simu.RDPG(x_mat, n, symm = TRUE, self = FALSE)
rdpg2 = simu.RDPG(y_mat, n, symm = TRUE, self = FALSE)
data1_mat = rdpg1$obs_mat
data2_mat = rdpg2$obs_mat
data_mat = cbind(data1_mat, data2_mat)
### detect change points
M = 20 # number of random intervals for WBS
d = 10 # parameter for scaled PCA algorithm
delta = 5
intervals = WBS.intervals(M = M, lower = 1, upper = ncol(data_mat))
WBS_result = WBS.nonpar.RDPG(data_mat, lowerdiag = TRUE, d, 
             Alpha = intervals$Alpha, Beta = intervals$Beta, delta)
cpt_hat = tuneBSnonparRDPG(WBS_result, data_mat, lowerdiag = TRUE, d)
}
\references{
Padilla, Yu and Priebe (2019) <arxiv:1911.07494>.
}
\seealso{
\code{\link{WBS.nonpar.RDPG}}.
}
\author{
Oscar Hernan Madrid Padilla & Haotian Xu
}
