% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address-provider-en_NZ.R
\name{AddressProvider_en_NZ}
\alias{AddressProvider_en_NZ}
\title{AddressProvider for New-Zealand}
\value{
Returns an AddressProvider object.
}
\description{
Object to create addresses for a locale.
Makes use of \link{PersonProvider} for creating street names.
}
\details{
When there is no PersonProvider for this locale, we default back to en_US.
}
\examples{
(z <- AddressProvider_en_NZ$new())
z$postcode()
z$street_name()
z$address()
z$city()
}
\seealso{
Other en: 
\code{\link{AddressProvider_en_GB}},
\code{\link{AddressProvider_en_US}},
\code{\link{ColorProvider_en_US}},
\code{\link{CompanyProvider_en_US}},
\code{\link{ElementProvider_en_US}},
\code{\link{FileProvider_en_US}},
\code{\link{InternetProvider_en_AU}},
\code{\link{InternetProvider_en_US}},
\code{\link{JobProvider_en_US}},
\code{\link{LoremProvider_en_US}},
\code{\link{PersonProvider_en_GB}},
\code{\link{PersonProvider_en_NZ}},
\code{\link{PersonProvider_en_US}},
\code{\link{PhoneNumberProvider_en_AU}},
\code{\link{PhoneNumberProvider_en_CA}},
\code{\link{PhoneNumberProvider_en_GB}},
\code{\link{PhoneNumberProvider_en_NZ}},
\code{\link{PhoneNumberProvider_en_US}},
\code{\link{PhoneNumberProvider_es_MX}},
\code{\link{SSNProvider_en_US}},
\code{\link{TaxonomyProvider_en_US}},
\code{\link{UserAgentProvider_en_US}},
\code{\link{english-language}}

Other NZ: 
\code{\link{PersonProvider_en_NZ}},
\code{\link{PhoneNumberProvider_en_NZ}}
}
\concept{NZ}
\concept{en}
\section{Super classes}{
\code{\link[charlatan:BareProvider]{charlatan::BareProvider}} -> \code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{\link[charlatan:AddressProvider]{charlatan::AddressProvider}} -> \code{AddressProvider_en_NZ}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AddressProvider_en_NZ-address}{\code{AddressProvider_en_NZ$address()}}
\item \href{#method-AddressProvider_en_NZ-city}{\code{AddressProvider_en_NZ$city()}}
\item \href{#method-AddressProvider_en_NZ-street_name}{\code{AddressProvider_en_NZ$street_name()}}
\item \href{#method-AddressProvider_en_NZ-street_address}{\code{AddressProvider_en_NZ$street_address()}}
\item \href{#method-AddressProvider_en_NZ-postcode}{\code{AddressProvider_en_NZ$postcode()}}
\item \href{#method-AddressProvider_en_NZ-clone}{\code{AddressProvider_en_NZ$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="bothify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-bothify'><code>charlatan::BareProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="lexify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-lexify'><code>charlatan::BareProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="numerify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-numerify'><code>charlatan::BareProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit'><code>charlatan::BareProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero'><code>charlatan::BareProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero_or_empty'><code>charlatan::BareProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_or_empty'><code>charlatan::BareProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element'><code>charlatan::BareProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element_prob"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element_prob'><code>charlatan::BareProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_int"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_int'><code>charlatan::BareProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_letter"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_letter'><code>charlatan::BareProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-randomize_nb_elements'><code>charlatan::BareProvider$randomize_nb_elements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="allowed_locales"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-allowed_locales'><code>charlatan::BaseProvider$allowed_locales()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="print"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-print'><code>charlatan::BaseProvider$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="AddressProvider" data-id="init_person_provider"><a href='../../charlatan/html/AddressProvider.html#method-AddressProvider-init_person_provider'><code>charlatan::AddressProvider$init_person_provider()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="AddressProvider" data-id="initialize"><a href='../../charlatan/html/AddressProvider.html#method-AddressProvider-initialize'><code>charlatan::AddressProvider$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_NZ-address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_NZ-address}{}}}
\subsection{Method \code{address()}}{
Create an address, a combination of street, postal code and city.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_NZ$address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_NZ-city"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_NZ-city}{}}}
\subsection{Method \code{city()}}{
Create a city
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_NZ$city()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_NZ-street_name"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_NZ-street_name}{}}}
\subsection{Method \code{street_name()}}{
Create a street name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_NZ$street_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_NZ-street_address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_NZ-street_address}{}}}
\subsection{Method \code{street_address()}}{
Create a street address , a combination of streetname and house indicator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_NZ$street_address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_NZ-postcode"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_NZ-postcode}{}}}
\subsection{Method \code{postcode()}}{
Create a postal code
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_NZ$postcode()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_en_NZ-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_en_NZ-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_en_NZ$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
