% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internet-provider.R
\name{InternetProvider}
\alias{InternetProvider}
\title{InternetProvider}
\value{
A InternetProvider object with specific functions for internet.
}
\description{
internet methods, e.g., email addresses, domain names

Note that if a locale you set doesn't have a locale specific set
of data for \link{PersonProvider} or \link{CompanyProvider} we fall back to
\code{en_US}
Also note that you
}
\seealso{
Other ParentProviders: 
\code{\link{AddressProvider}},
\code{\link{ColorProvider}},
\code{\link{CompanyProvider}},
\code{\link{JobProvider}},
\code{\link{LoremProvider}},
\code{\link{PersonProvider}},
\code{\link{PhoneNumberProvider}},
\code{\link{TaxonomyProvider}},
\code{\link{UserAgentProvider}}
}
\concept{ParentProviders}
\section{Super classes}{
\code{\link[charlatan:BareProvider]{charlatan::BareProvider}} -> \code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{InternetProvider}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InternetProvider-new}{\code{InternetProvider$new()}}
\item \href{#method-InternetProvider-to_ascii}{\code{InternetProvider$to_ascii()}}
\item \href{#method-InternetProvider-email}{\code{InternetProvider$email()}}
\item \href{#method-InternetProvider-safe_email}{\code{InternetProvider$safe_email()}}
\item \href{#method-InternetProvider-free_email}{\code{InternetProvider$free_email()}}
\item \href{#method-InternetProvider-company_email}{\code{InternetProvider$company_email()}}
\item \href{#method-InternetProvider-ascii_email}{\code{InternetProvider$ascii_email()}}
\item \href{#method-InternetProvider-ascii_safe_email}{\code{InternetProvider$ascii_safe_email()}}
\item \href{#method-InternetProvider-ascii_free_email}{\code{InternetProvider$ascii_free_email()}}
\item \href{#method-InternetProvider-ascii_company_email}{\code{InternetProvider$ascii_company_email()}}
\item \href{#method-InternetProvider-user_name}{\code{InternetProvider$user_name()}}
\item \href{#method-InternetProvider-tld}{\code{InternetProvider$tld()}}
\item \href{#method-InternetProvider-free_email_domain}{\code{InternetProvider$free_email_domain()}}
\item \href{#method-InternetProvider-url}{\code{InternetProvider$url()}}
\item \href{#method-InternetProvider-domain_name}{\code{InternetProvider$domain_name()}}
\item \href{#method-InternetProvider-domain_word}{\code{InternetProvider$domain_word()}}
\item \href{#method-InternetProvider-ipv4}{\code{InternetProvider$ipv4()}}
\item \href{#method-InternetProvider-ipv6}{\code{InternetProvider$ipv6()}}
\item \href{#method-InternetProvider-mac_address}{\code{InternetProvider$mac_address()}}
\item \href{#method-InternetProvider-uri_page}{\code{InternetProvider$uri_page()}}
\item \href{#method-InternetProvider-uri_path}{\code{InternetProvider$uri_path()}}
\item \href{#method-InternetProvider-uri_extension}{\code{InternetProvider$uri_extension()}}
\item \href{#method-InternetProvider-uri}{\code{InternetProvider$uri()}}
\item \href{#method-InternetProvider-slug}{\code{InternetProvider$slug()}}
\item \href{#method-InternetProvider-image_url}{\code{InternetProvider$image_url()}}
\item \href{#method-InternetProvider-clone}{\code{InternetProvider$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="bothify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-bothify'><code>charlatan::BareProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="lexify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-lexify'><code>charlatan::BareProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="numerify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-numerify'><code>charlatan::BareProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit'><code>charlatan::BareProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero'><code>charlatan::BareProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero_or_empty'><code>charlatan::BareProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_or_empty'><code>charlatan::BareProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element'><code>charlatan::BareProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element_prob"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element_prob'><code>charlatan::BareProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_int"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_int'><code>charlatan::BareProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_letter"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_letter'><code>charlatan::BareProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-randomize_nb_elements'><code>charlatan::BareProvider$randomize_nb_elements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="allowed_locales"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-allowed_locales'><code>charlatan::BaseProvider$allowed_locales()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="print"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-print'><code>charlatan::BaseProvider$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-new"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-new}{}}}
\subsection{Method \code{new()}}{
Create a new Provider object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-to_ascii"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-to_ascii}{}}}
\subsection{Method \code{to_ascii()}}{
convert to ascii
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$to_ascii(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{the stringn to convert to ascii}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-email"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-email}{}}}
\subsection{Method \code{email()}}{
get an email address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$email(domain = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{domain}}{(character) a domain name, if not given, a random
name is chosen}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-safe_email"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-safe_email}{}}}
\subsection{Method \code{safe_email()}}{
get a safe email address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$safe_email()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-free_email"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-free_email}{}}}
\subsection{Method \code{free_email()}}{
a free email address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$free_email()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-company_email"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-company_email}{}}}
\subsection{Method \code{company_email()}}{
company email address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$company_email()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-ascii_email"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-ascii_email}{}}}
\subsection{Method \code{ascii_email()}}{
ascii email address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$ascii_email()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-ascii_safe_email"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-ascii_safe_email}{}}}
\subsection{Method \code{ascii_safe_email()}}{
safe ascii email address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$ascii_safe_email()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-ascii_free_email"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-ascii_free_email}{}}}
\subsection{Method \code{ascii_free_email()}}{
an ascii free email address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$ascii_free_email()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-ascii_company_email"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-ascii_company_email}{}}}
\subsection{Method \code{ascii_company_email()}}{
ascii company email address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$ascii_company_email()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-user_name"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-user_name}{}}}
\subsection{Method \code{user_name()}}{
a user name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$user_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-tld"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-tld}{}}}
\subsection{Method \code{tld()}}{
a tld
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$tld()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-free_email_domain"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-free_email_domain}{}}}
\subsection{Method \code{free_email_domain()}}{
free email domain name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$free_email_domain()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-url"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-url}{}}}
\subsection{Method \code{url()}}{
a url
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$url(schemes = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{schemes}}{(character vector) a url scheme, defaults are http and https}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-domain_name"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-domain_name}{}}}
\subsection{Method \code{domain_name()}}{
Produce an Internet domain name with the specified
number of subdomain levels
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$domain_name(levels = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{levels}}{(integer) how many levels, must be >1}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-domain_word"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-domain_word}{}}}
\subsection{Method \code{domain_word()}}{
a domain word
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$domain_word()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-ipv4"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-ipv4}{}}}
\subsection{Method \code{ipv4()}}{
an ipv4 address or network
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$ipv4(network = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network}}{(logical) produce a network}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-ipv6"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-ipv6}{}}}
\subsection{Method \code{ipv6()}}{
an ipv6 address or network
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$ipv6(network = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network}}{(logical) produce a network}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-mac_address"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-mac_address}{}}}
\subsection{Method \code{mac_address()}}{
a mac address
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$mac_address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-uri_page"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-uri_page}{}}}
\subsection{Method \code{uri_page()}}{
a uri page
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$uri_page()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-uri_path"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-uri_path}{}}}
\subsection{Method \code{uri_path()}}{
a uri path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$uri_path(deep = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{how deep to go, an integer, if not given an integer
between 1 and 4 (inclusive) is chosen}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-uri_extension"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-uri_extension}{}}}
\subsection{Method \code{uri_extension()}}{
a uri extension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$uri_extension()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-uri"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-uri}{}}}
\subsection{Method \code{uri()}}{
a uri
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$uri()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-slug"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-slug}{}}}
\subsection{Method \code{slug()}}{
a slug
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$slug(value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{(character) a string, if given, returns itself, if not, uses
\link{LoremProvider} to get a random string. default: \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-image_url"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-image_url}{}}}
\subsection{Method \code{image_url()}}{
Returns URL to placeholder image -
Example: http://placehold.it/640x480
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$image_url(width = NULL, height = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{image width, in pixels}

\item{\code{height}}{image height, in pixels}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InternetProvider-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InternetProvider-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InternetProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
