% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_clusterings.R
\name{homogeneity}
\alias{homogeneity}
\title{Homogeneity Between Clusterings}
\usage{
homogeneity(true, pred)
}
\arguments{
\item{true}{ground truth clustering represented as a membership
vector. Each entry corresponds to an element and the value identifies
the assigned cluster. The specific values of the cluster identifiers
are arbitrary.}

\item{pred}{predicted clustering represented as a membership
vector.}
}
\description{
Computes the homogeneity between two clusterings, such
as a predicted and ground truth clustering.
}
\details{
Homogeneity is an entropy-based measure of the similarity
between two clusterings, say \eqn{t} and \eqn{p}. The homogeneity
is high if clustering \eqn{t} only assigns members of a cluster to
a single cluster in \eqn{p}. The homogeneity ranges between 0
and 1, where 1 indicates a perfect homogeneity.
}
\examples{
true <- c(1,1,1,2,2)  # ground truth clustering
pred <- c(1,1,2,2,2)  # predicted clustering
homogeneity(true, pred)

}
\references{
Rosenberg, A. and Hirschberg, J. "V-measure: A conditional entropy-based external cluster evaluation measure." \emph{Proceedings of the 2007 Joint Conference on Empirical Methods in Natural Language Processing and Computational Natural Language Learning} (EMNLP-CoNLL), (2007).
}
\seealso{
\code{\link{completeness}} evaluates the \emph{completeness}, which is a dual
measure to \emph{homogeneity}. \code{\link{v_measure}} evaluates the harmonic mean of
\emph{completeness} and \emph{homogeneity}.
}
