% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock_chart_qnt.R
\name{clock_chart_qnt}
\alias{clock_chart_qnt}
\title{Clock Chart, Length and Color Modified by Numeric Variables}
\usage{
clock_chart_qnt(data, time, len, Col = NULL, high = "red", low = "green")
}
\arguments{
\item{data}{A data frame}

\item{time}{Time in 24 hours. The allowed time formats for these family
of charts are \code{HH:MM:SS}, \code{HH:MM} or even \code{H:M} (such as \verb{12;30:09}
or \code{9:3}).}

\item{len}{The numeric vector by which hands will be modified and colored.}

\item{Col}{Optional. A numeric vector to change color. This option will be
discontinued.}

\item{high}{The color name for the high values. The default is \code{red}.}

\item{low}{The color name for the low values. The default is \code{green}.
The color names can be vice versa or other colors, depending on the context.
To use a single color for all lines, use same value for \code{high} and \code{low}.}
}
\value{
A \code{ggplot} object, which can be further modified
with \code{ggplot2} functions and themes.
}
\description{
This function will plot time of events on a 24 hour clock to show which
events took place at what times. The length and color of the hands are
modified according to a numeric vector.
}
\details{
Change the title, subtitle or the caption of the plot with
\code{ggplot2::labs()} .Change the legend title by adding
\code{ggplot2::labs(color = "TITLE 1", size = "TITLE2")}.
Add
or modify legend by \code{theme(legend.position = "POSITION")}; the valid
position names in \code{ggplot2} are \code{top}, \code{bottom}, \code{right}, and \code{left},
excluding more complex options.
}
\examples{
p1 <- clock_chart_qnt(
  data = bdquake, time = hms, len = depth,
  Col = mag, high = "red", low = "blue"
)
p1 + ggplot2::labs(
  color = "Depth", size = "Magnitude",
  title = "Earthquakes in Bangladesh since 2023"
)
}
\seealso{
\code{\link[=clock_chart_col]{clock_chart_col()}} for coloring by a numeric variable,
\code{\link[=clock_chart_qlt]{clock_chart_qlt()}} for coloring by a qualitative variable,
\code{\link[=clock_chart]{clock_chart()}} for the simplest clock chart
}
